/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecurityCheckManager {
    private ConfigurationManager configurationManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;

    @Autowired
    public SecurityCheckManager(ConfigurationManager configurationManager, UserAccessor userAccessor, UserManager userManager) {
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
    }

    public Boolean isUserHasPermissions() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String gdprGroupString = this.configurationManager.getRunGdprGroup();
        return !(!this.userManager.isAdmin(user.getKey()) && !this.userManager.isSystemAdmin(user.getKey()) || !StringUtils.isBlank((CharSequence)gdprGroupString) && !this.userAccessor.hasMembership(gdprGroupString, user.getName()));
    }

    public Boolean isUserConfluenceAdmin(ConfluenceUser confluenceUser) {
        return true;
    }
}

