define("actonic-gdpr/data-level-agreement/rules", ["jquery", "actonic-gdpr/data-level-agreement/rest", "actonic-gdpr/core/flags"], function ($, Rest, flags) {

    function Rules() {
        var action, currentRule, currentRuleId;

        this.init = function () {
            var ruleId = getParameterByName(location.href, "ruleId");
            if (ruleId) {
                action = "save";
                loadRule(ruleId);
            } else {
                action = "create";
            }

            $("#save-button").click(function () {
                if (action == "create") createRule();
                if (action == "save") updateRule();
            });

            $("#rule-action").change(function () {
                handleParameterFields($(this).val());
            });

            $("#rule-notification-type").change(function () {
                handleParameterNotifications($(this).val());
            });

            $("#rule-notification-grouping").change(function () {
                if ($(this).val() == "default") {
                    $("#rule-notification-text").parent().find(".description-default").show();
                    $("#rule-notification-text").parent().find(".description-grouping").hide();
                } else {
                    $("#rule-notification-text").parent().find(".description-default").hide();
                    $("#rule-notification-text").parent().find(".description-grouping").show();
                }
            });

            $("#rule-action-notification-item").change(function () {
                handleParameterSelectUsers($(this).val());
            });

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            initializeGroupPicker();
            checkForProperPluginConfiguration();
        };

        function initializeGroupPicker(initialGroup) {
            var parent = $("#rule-security-parameter-group").parent();
            $("#rule-security-parameter-group").remove();
            $("#s2id_rule-security-parameter-group").remove();
            $(parent).append("<input type=\"text\" class=\"text long-field\" id=\"rule-security-parameter-group\">");

            AJS.$("#rule-security-parameter-group").auiSelect2({
                placeholder: AJS.I18n.getText("js-dla.rules.placeholder.select-group"),
                allowClear: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/groups",
                    data: function (term) {
                        return {
                            query: term,
                            maxResults: 100
                        };
                    },
                    results: function (data) {
                        //log.debug("initializeTargetGroupPicker = " + JSON.stringify(data));
                        var results = [];
                        $.each(data, function (index, item) {
                            results.push({id: item.text, text: item.text});
                        });
                        return {
                            results: results
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (initialGroup) {
                        callback({id: initialGroup, text: initialGroup});
                    }
                }
            });

            if (initialGroup) {
                $("#rule-security-parameter-group").val(initialGroup).trigger("change");
            }
        }

        function checkForProperPluginConfiguration() {
            Rest.getDataRulesConfigurationStatus(
                function (data) {
                    if (!data || data.status == "error") {
                        flags.show({
                            type: "error",
                            close: "manual",
                            body: "<p>" + AJS.I18n.getText("js-dla.rules.rest.get-config-rule.flag.error.title") + "</p>" +
                                "<p><b>" + data.message + "</b></p>" +
                                "<p>" + AJS.I18n.getText("js-dla.rules.rest.get-config-rule.flag.error.desc") + "</p>"
                        });
                    }
                },
                function (error) {
                    log.error("Rest.getDataRulesConfigurationStatus error = " + JSON.stringify(error));
                });
        }

        function handleParameterFields(currentType) {
            // disable everything
            $("#rule-action-notification-item").parent().hide();
            $("#rule-comment-parameter-text").parent().hide();
            $("#rule-security-parameter-group").parent().hide();

            $("#rule-notification-parameter-external-emails").parent().hide();
            $("#rule-notification-subject").parent().hide();
            $("#rule-notification-text").parent().hide();
            $("input[name=delete-options]").parent().parent().hide();
            $("input[name=trash-options]").parent().parent().hide();
            $("#rule-notification-grouping").parent().hide();

            // enable only selected
            if (currentType == "notification") {
                $("#rule-notification-grouping").parent().show();
                $("#rule-action-notification-item").parent().show();
                $("#rule-notification-subject").parent().show();
                $("#rule-notification-text").parent().show();
                $("#rule-notification-grouping").trigger("change");
            }
            if (currentType == "comment") {
                $("#rule-comment-parameter-text").parent().show();
            }
            if (currentType == "security") {
                $("#rule-security-parameter-group").parent().show();
            }
            if (currentType == "delete") {
                $("input[name=delete-options]").parent().parent().show();
            }
            if (currentType == "trash") {
                $("input[name=trash-options]").parent().parent().show();
            }
        }

        function handleParameterSelectUsers(currentType) {
            $("#rule-notification-parameter-external-emails").parent().hide();

            if (currentType == "external-emails") {
                $("#rule-notification-parameter-external-emails").parent().show();
            }
        }

        function handleParameterNotifications(currentType) {
            if (currentType == "email")
                $("#rule-notification-parameter-emails").parent().show();
            else $("#rule-notification-parameter-emails").parent().hide();
        }

        function loadRule(ruleId) {
            Rest.getRule(ruleId,
                function (data) { // success
                    //console.log("Rest.getRule data", data);
                    currentRule = data;
                    currentRuleId = data.id;

                    $("#rule-enabled").prop("checked", data.enabled);
                    $("#rule-name").val(data.name);
                    $("#rule-cron").val(data.cron);
                    $("#rule-cql").val(data.cql);
                    $("#rule-action").val(data.type).trigger("change");
                    $("#rule-notification-type").val(data.notificationType).trigger("change");

                    if (data.parameters) {
                        var parameters = JSON.parse(data.parameters);
                        currentRule.parameters = parameters;

                        if (data.type == "notification") {
                            $("#rule-action-notification-item").val(parameters.notification).trigger("change");
                            $("#rule-notification-subject").val(parameters.subject);
                            $("#rule-notification-text").val(parameters.message);
                            $("#rule-notification-grouping").val(parameters.grouping).trigger("change");
                            if (parameters.notification == "external-emails") {
                                $("#rule-notification-parameter-external-emails").val(parameters.externalEmails);
                            }
                        }
                        if (data.type == "comment") {
                            $("#rule-comment-parameter-text").val(parameters.comment);
                        }
                        if (data.type == "security") {
                            initializeGroupPicker(parameters.group);
                        }
                        if (data.type == "delete" && parameters.deleteOption) {
                            $("input[name='delete-options']").filter('[value=' + parameters.deleteOption + ']').prop('checked', true);
                        }
                        if (data.type == "trash" && parameters.trashOption) {
                            $("input[name='trash-options']").filter('[value=' + parameters.trashOption + ']').prop('checked', true);
                        }
                    }
                    if (data.notificationParameters) {
                        var notificationParameters = data.notificationParameters;
                        if (data.notificationType == "email")
                            $("#rule-notification-parameter-emails").val(notificationParameters.emails);
                    }
                },
                function (error) {
                    log.error("Rest.getRule error = " + JSON.stringify(error));
                });
        }

        function createRule() {
            validation(function () { // success
                $("#progress-indicator").show();

                var request = getRuleRequest();

                // log.debug("createRule request = " + JSON.stringify(request));
                Rest.createRule(request,
                    function (data) { // success
                        // log.debug("Rest.createRule data = " + JSON.stringify(data));
                        flags.showFlag(AJS.I18n.getText("js-dla.rules.rest.create-rule.flag.info.title"), AJS.I18n.getText("js-dla.rules.rest.create-rule.flag.info.desc"), "info");

                        setTimeout(function () {
                            location.href = "data-rules.action";
                        }, 1000);
                    },
                    function (error) {
                        log.error("Rest.createRule error = " + JSON.stringify(error));
                    });
            });
        }

        function getRuleRequest() {
            var enabled = $("#rule-enabled").prop("checked");
            var ruleName = $("#rule-name").val();
            var ruleCron = $("#rule-cron").val();
            var ruleCql = $("#rule-cql").val();
            var ruleAction = $("#rule-action").val();
            var ruleNotificationType = $("#rule-notification-type").val();

            var request = {
                enabled: enabled,
                name: ruleName,
                cron: ruleCron,
                cql: ruleCql,
                type: ruleAction,
                notificationType: ruleNotificationType
            };

            if (ruleAction == "notification") {
                var notification = $("#rule-action-notification-item").val();
                var grouping = $("#rule-notification-grouping").val();
                var externalEmails = $("#rule-notification-parameter-external-emails").val();
                var subject = $("#rule-notification-subject").val();
                var message = $("#rule-notification-text").val();

                var parameters = {
                    notification: notification,
                    grouping: grouping,
                    externalEmails: externalEmails,
                    subject: subject,
                    message: message
                };

                request.parameters = JSON.stringify(parameters);
                //request.notificationParameters = JSON.stringify(notificationParameters);
            }
            if (ruleAction == "comment") {
                var comment = $("#rule-comment-parameter-text").val();
                var parameters = {
                    comment: comment
                };
                request.parameters = JSON.stringify(parameters);
            }
            if (ruleAction == "security") {
                var group = $("#rule-security-parameter-group").val();
                var parameters = {
                    group: group
                };
                request.parameters = JSON.stringify(parameters);
            }
            if (ruleAction == "delete") {
                var deleteOption = $("input[name='delete-options']:checked").val();
                var parameters = {
                    deleteOption: deleteOption
                };
                request.parameters = JSON.stringify(parameters);
            }
            if (ruleAction == "trash") {
                var trashOption = $("input[name='trash-options']:checked").val();
                var parameters = {
                    trashOption: trashOption
                };
                request.parameters = JSON.stringify(parameters);
            }
            if (ruleNotificationType == "email") {
                var emails = $("#rule-notification-parameter-emails").val();
                var notificationParameters = {
                    emails: emails
                };
                request.notificationParameters = JSON.stringify(notificationParameters);
            }

            return request;
        }

        function updateRule() {
            validation(function () { // success
                $("#progress-indicator").show();

                var request = getRuleRequest();

                //console.log("createRule request = " + JSON.stringify(request));
                Rest.updateRule(currentRuleId, request,
                    function (data) { // success
                        // log.debug("Rest.createRule data = " + JSON.stringify(data));
                        flags.showFlag(AJS.I18n.getText("js-dla.rules.rest.update-rule.flag.info.title"), AJS.I18n.getText("js-dla.rules.rest.update-rule.flag.info.desc"), "info");

                        setTimeout(function () {
                            location.href = "data-rules.action";
                        }, 1000);
                    },
                    function (error) {
                        log.error("Rest.updateRule error = " + JSON.stringify(error));
                    });
            });
        }

        function getParameterByName(url, name) {
            name = name.replace(/[\[\]]/g, "\\$&");
            var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';

            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }

        function validateEmail(email) {
            var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            return re.test(String(email).toLowerCase());
        }

        function validation(successCallback) {
            if (!$("#rule-name").val()) {
                flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.name-empty"), "warning");
                highlightElement($("#rule-name"));
                return;
            }
            if (!$("#rule-cron").val()) {
                flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.cron-empty"), "warning");
                highlightElement($("#rule-cron"));
                return;
            }
            if (!$("#rule-cql").val()) {
                flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.cql-empty"), "warning");
                highlightElement($("#rule-cql"));
                return;
            }

            if ($("#rule-action").val() == "comment") {
                if (!$("#rule-comment-parameter-text").val()) {
                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.comment-empty"), "warning");
                    highlightElement($("#rule-comment-parameter-text"));
                    return;
                }
            }
            if ($("#rule-action").val() == "security") {
                if (!$("#rule-security-parameter-group").val()) {
                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.select-group"), "warning");
                    highlightElement($("#rule-security-parameter-group"));
                    return;
                }
            }

            if ($("#rule-notification-type").val() == "email") {
                var emails = $("#rule-notification-parameter-emails").val().split(",");
                var isEmailValid = true;
                emails.forEach(function (email) {
                    if (!validateEmail(email.trim())) isEmailValid = false;
                });
                //log.debug("validateEmail = " + JSON.stringify(validateEmail(emails)));
                if (!isEmailValid) {
                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-email"), "warning");
                    highlightElement($("#rule-notification-parameter-emails"));
                    return;
                }
            }

            if ($("#rule-action-notification-item").val() == "external-emails") {
                var emails = $("#rule-notification-parameter-external-emails").val().split(",");
                var isEmailValid = true;
                emails.forEach(function (email) {
                    if (!validateEmail(email.trim())) isEmailValid = false;
                });
                //log.debug("validateEmail = " + JSON.stringify(validateEmail(emails)));
                if (!isEmailValid) {
                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-email"), "warning");
                    highlightElement($("#rule-notification-parameter-external-emails"));
                    return;
                }
            }

            if ($("#rule-action").val() == "notification") {
                if (!$("#rule-notification-subject").val()) {
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Subject could not be empty", "warning");
                    highlightElement($("#rule-notification-subject"));
                    return;
                }
                if (!$("#rule-notification-text").val()) {
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Message could not be empty", "warning");
                    highlightElement($("#rule-notification-text"));
                    return;
                }
            }

            Rest.checkCron($("#rule-cron").val(),
                function (data) {
                    // log.debug("Rest.checkCron data = " + JSON.stringify(data));
                    if (data) {
                        Rest.checkCql($("#rule-cql").val(),
                            function (data) {
                                //console.log("Rest.checkJql data ", data);
                                if (data.value) {
                                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-cql") + " " + data.value, "warning");
                                    highlightElement($("#rule-cql"));
                                } else {
                                    successCallback();
                                }
                            },
                            function () {
                                flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-cron"), "error");
                                highlightElement($("#rule-cron"));
                            });
                    } else {
                        flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-cron-and-duration"), "warning");
                        highlightElement($("#rule-cron"));
                    }
                },
                function () {
                    flags.showFlag(AJS.I18n.getText("js-dla.rules.validate.warning.title"), AJS.I18n.getText("js-dla.rules.validate.warning.invalid-cron"), "error");
                    highlightElement($("#rule-cron"));
                });
        }

        function highlightElement(element) {
            $(element).addClass("red-border");
            setTimeout(function () {
                $(element).removeClass("red-border");
            }, 3000);
        }
    }

    return new Rules();
});
