define("gdpr/core/aui-picker", ["jquery"], function ($) {
    function Picker() {

        this.initSpacePicker = function (selector, multiple, selectedValue) {
            console.log(selectedValue);

            var parent = $("#" + selector).parent();
            $("#" + selector).remove();
            $("#s2id_" + selector).remove();
            $(parent).append("<input class=\"select\" type=\"text\" id=\"" + selector + "\">");

            var initialValues = [];
            var initialNames = [];
            if (selectedValue) {
                if (Array.isArray(selectedValue)) {
                    selectedValue.forEach(function (value) {
                        initialValues.push({id: value, text: value});
                        initialNames.push(value);
                    });
                } else {
                    if (multiple) {
                        initialValues.push({id: selectedValue, text: selectedValue});
                        initialNames.push(selectedValue);
                    } else {
                        initialValues = {id: selectedValue, text: selectedValue};
                        initialNames.push(selectedValue);
                    }
                }
            }
            console.log(initialValues);

            AJS.$("#" + selector).auiSelect2({
                placeholder: AJS.I18n.getText("js-aui-picker.placeholder-select-space"),
                allowClear: true,
                multiple: multiple,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/spaces",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        console.log(data);
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (selectedValue) {
                        callback(initialValues);
                    }
                }
            });

            if (selectedValue) {
                $("#" + selector).val(initialNames).trigger("change");
            }
        };

        this.initUserPicker = function (selector, multiple, selectedValue) {
            var parent = $("#" + selector).parent();
            $("#" + selector).remove();
            $("#s2id_" + selector).remove();
            $(parent).append("<input class=\"select\" type=\"text\" id=\"" + selector + "\">");

            var initialValues = [];
            var initialNames = [];
            if (selectedValue) {
                if (Array.isArray(selectedValue)) {
                    selectedValue.forEach(function (userName) {
                        initialValues.push({id: userName, text: userName});
                        initialNames.push(userName);
                    });
                } else {
                    initialValues.push({id: selectedValue, text: selectedValue});
                    initialNames.push(selectedValue);
                }
            }

            AJS.$("#" + selector).auiSelect2({
                placeholder: AJS.I18n.getText("js-aui-picker.placeholder-select-user"),
                allowClear: true,
                multiple: multiple,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: 'json',
                    url: AJS.contextPath() + "/rest/api/search?start=0&limit=20",
                    data: function (term) {
                        if (term) {
                            return {
                                cql: "user ~ '" + term + "'"
                            };
                        } else {
                            return {
                                cql: "user ~ '*'"
                            };
                        }
                    },
                    results: function (data) {
                        return {
                            results: $.map(data.results, function (el) {
                                //log.debug(el);
                                return {
                                    id: el.user.username,
                                    text: el.user.displayName + ' (' + el.user.username + ')'
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (selectedValue) {
                        callback(initialValues);
                    }
                }
            });

            if (selectedValue) {
                $("#" + selector).val(initialNames).trigger("change");
            }
        }

        this.initPagePicker = function (selector, multiple, selectedValue) {
            var parent = $("#" + selector).parent();
            $("#" + selector).remove();
            $("#s2id_" + selector).remove();
            $(parent).append("<input class=\"select\" type=\"text\" id=\"" + selector + "\">");

            var initialValues = [];
            var initialNames = [];
            if (selectedValue) {
                if (Array.isArray(selectedValue)) {
                    selectedValue.forEach(function (page) {
                        initialValues.push({id: page, text: page});
                        initialNames.push(page);
                    });
                } else {
                    initialValues.push({id: selectedValue, text: selectedValue});
                    initialNames.push(selectedValue);
                }
            }

            AJS.$("#" + selector).auiSelect2({
                placeholder: AJS.I18n.getText("js-aui-picker.placeholder-select-page"),
                allowClear: true,
                multiple: multiple,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/pages",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (selectedValue) {
                        callback(initialValues);
                    }
                }
            });

            if (selectedValue) {
                $("#" + selector).val(initialNames).trigger("change");
            }
        }

        this.initLabelPicker = function (selector, multiple, selectedValue) {
            var parent = $("#" + selector).parent();
            $("#" + selector).remove();
            $("#s2id_" + selector).remove();
            $(parent).append("<input class=\"select\" type=\"text\" id=\"" + selector + "\">");

            var initialValues = [];
            var initialNames = [];
            if (selectedValue) {
                if (Array.isArray(selectedValue)) {
                    selectedValue.forEach(function (page) {
                        initialValues.push({id: page, text: page});
                        initialNames.push(page);
                    });
                } else {
                    initialValues.push({id: selectedValue, text: selectedValue});
                    initialNames.push(selectedValue);
                }
            }

            AJS.$("#" + selector).auiSelect2({
                placeholder: AJS.I18n.getText("js-aui-picker.placeholder-select-label"),
                allowClear: true,
                multiple: multiple,
                ajax: {
                    url: AJS.contextPath() + "/labels/autocompletelabel.action?maxResults=10",
                    dataType: "json",
                    data: function (term) {
                        return {
                            query: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data.contentNameMatches, function (el) {
                                return {
                                    id: el[0].name,
                                    text: el[0].name
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (selectedValue) {
                        callback(initialValues);
                    }
                }
            });

            if (selectedValue) {
                $("#" + selector).val(initialNames).trigger("change");
            }
        };

        this.initDatePicker = function (selector, selectedValue) {
            $("#" + selector).datePicker({"overrideBrowserDefault": true});
            if (selectedValue)
                $("#" + selector).val(selectedValue);

        }
    }

    return new Picker();
});
