/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Strings;
import de.actonic.gdpr.shared.general.manager.GDPRAbstractSettingsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GDPRSettingsManager
extends GDPRAbstractSettingsManager {
    private final PluginSettings pluginSettings;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public GDPRSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginAccessor pluginAccessor) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.jira.gdpr");
        this.pluginAccessor = pluginAccessor;
    }

    public Object getFieldByName(String name) {
        return null;
    }

    public void setFieldByName(String name, String value) {
    }

    public Integer getRowsPerPage() {
        String rowsPerPage = (String)this.pluginSettings.get("ROWS_PER_PAGE");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return ROWS_PER_PAGE_DEFAULT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setRowsPerPage(int rowsPerPage) {
        if (rowsPerPage <= 0 || rowsPerPage > ROWS_PER_PAGE_MAX_VALUE) {
            rowsPerPage = ROWS_PER_PAGE_DEFAULT_VALUE;
        }
        this.pluginSettings.put("ROWS_PER_PAGE", (Object)String.valueOf(rowsPerPage));
    }

    public void setRowsPerPageAsString(String rowsPerPage) {
        try {
            Integer integer = Integer.parseInt(rowsPerPage);
            if (integer <= 0 || integer > ROWS_PER_PAGE_MAX_VALUE) {
                rowsPerPage = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            rowsPerPage = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
        }
        this.pluginSettings.put("ROWS_PER_PAGE", (Object)rowsPerPage);
    }

    public boolean getTrackIssueAccessStatistics() {
        String trackIssueAccessStatistics = (String)this.pluginSettings.get("TRACK_ISSUE_ACCESS_STATISTICS");
        if (Strings.isNullOrEmpty((String)trackIssueAccessStatistics) || Boolean.valueOf(trackIssueAccessStatistics) == null) {
            return false;
        }
        return Boolean.valueOf(trackIssueAccessStatistics);
    }

    public void setTrackIssueAccessStatistics(boolean trackIssueAccessStatistics) {
        this.pluginSettings.put("TRACK_ISSUE_ACCESS_STATISTICS", (Object)String.valueOf(trackIssueAccessStatistics));
    }

    public boolean getShowAnnouncementInRealTime() {
        String showAnnouncementInRealTime = (String)this.pluginSettings.get("SHOW_ANNOUNCEMENT_IN_REAL_TIME");
        if (Strings.isNullOrEmpty((String)showAnnouncementInRealTime) || Boolean.valueOf(showAnnouncementInRealTime) == null) {
            return true;
        }
        return Boolean.valueOf(showAnnouncementInRealTime);
    }

    public void setShowAnnouncementInRealTime(boolean showAnnouncementInRealTime) {
        this.pluginSettings.put("SHOW_ANNOUNCEMENT_IN_REAL_TIME", (Object)String.valueOf(showAnnouncementInRealTime));
    }

    public Integer getPurgeAccessStatisticsAfter() {
        String purgeAccessStatisticsAfter = (String)this.pluginSettings.get("PURGE_ACCESS_STATISTICS_AFTER");
        if (Strings.isNullOrEmpty((String)purgeAccessStatisticsAfter) || Integer.valueOf(purgeAccessStatisticsAfter) <= 30 || Integer.valueOf(purgeAccessStatisticsAfter) > 9999) {
            return PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE;
        }
        return Integer.valueOf(purgeAccessStatisticsAfter);
    }

    public void setPurgeAccessStatisticsAfter(int purgeAccessStatisticsAfter) {
        if (purgeAccessStatisticsAfter <= PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE || purgeAccessStatisticsAfter > PURGE_ACCESS_STATISTICS_AFTER_MAX_VALUE) {
            purgeAccessStatisticsAfter = PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE;
        }
        this.pluginSettings.put("PURGE_ACCESS_STATISTICS_AFTER", (Object)String.valueOf(purgeAccessStatisticsAfter));
    }

    public void setPurgeAccessStatisticsAfterAsString(String purgeAccessStatisticsAfter) {
        try {
            Integer integer = Integer.parseInt(purgeAccessStatisticsAfter);
            if (integer <= PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE || integer > PURGE_ACCESS_STATISTICS_AFTER_MAX_VALUE) {
                purgeAccessStatisticsAfter = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            purgeAccessStatisticsAfter = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
        }
        this.pluginSettings.put("PURGE_ACCESS_STATISTICS_AFTER", (Object)purgeAccessStatisticsAfter);
    }

    public String getRunTasksFromUser() {
        return (String)this.pluginSettings.get("RUN_TASKS_FROM_USER");
    }

    public void setRunTasksFromUser(String runTasksFromUserKey) {
        this.pluginSettings.put("RUN_TASKS_FROM_USER", (Object)runTasksFromUserKey);
    }

    public String getAllowedGroup() {
        return (String)this.pluginSettings.get("ALLOWED_GROUP_PROPERTY_NAME");
    }

    public void setAllowedGroup(String allowedGroup) {
        this.pluginSettings.put("ALLOWED_GROUP_PROPERTY_NAME", (Object)allowedGroup);
    }

    public boolean isJiraServiceManagementInstalled() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.servicedesk") || this.pluginAccessor.isPluginEnabled("servicedesk");
    }

    public Integer getExecutionHistoryCount() {
        String rowsPerPage = (String)this.pluginSettings.get("HISTORY_COUNT");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return EXECUTION_HISTORY_COUNT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionHistoryCount(Integer executionHistoryCount) {
        this.pluginSettings.put("HISTORY_COUNT", (Object)String.valueOf(executionHistoryCount));
    }

    public Integer getExecutionEntriesCount() {
        String rowsPerPage = (String)this.pluginSettings.get("ENTRIES_NAME");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return EXECUTION_ENTRIES_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionEntriesCount(Integer executionEntriesCount) {
        this.pluginSettings.put("ENTRIES_NAME", (Object)String.valueOf(executionEntriesCount));
    }

    public Integer getTaskTimeout() {
        String taskTimeout = (String)this.pluginSettings.get("TASK_TIMEOUT");
        if (Strings.isNullOrEmpty((String)taskTimeout) || Integer.parseInt(taskTimeout) <= 0) {
            return TASK_TIMEOUT_DEFAULT_VALUE;
        }
        return Integer.valueOf(taskTimeout);
    }

    public void setTaskTimeout(Integer timeout) {
        this.pluginSettings.put("TASK_TIMEOUT", (Object)String.valueOf(timeout));
    }
}

