/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import de.actonic.gdpr.shared.general.manager.IGDPRParentContentManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GDPRParentContentManager
implements IGDPRParentContentManager {
    private final SpaceManager spaceManager;

    @Autowired
    public GDPRParentContentManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public Collection<String> getAllParentContent() {
        return this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT);
    }

    public Map<String, String> filterParentContent(List<String> projectKeys, String projectPartName) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String spaceKey : projectKeys) {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                result.put(spaceKey + "(deleted)", spaceKey);
                continue;
            }
            if (projectPartName == null) {
                result.put(space.getName(), spaceKey);
                continue;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)space.getName(), (CharSequence)projectPartName)) continue;
            result.put(space.getName(), spaceKey);
        }
        return result;
    }
}

