/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.manager;

import de.actonic.gdpr.datacleaner.ao.DCIgnoreEntity;
import de.actonic.gdpr.datacleaner.dao.DCIgnoreDao;
import de.actonic.gdpr.shared.datacleaner.manager.IDCIgnoreManager;
import de.actonic.gdpr.shared.datacleaner.model.DCIgnoreImportExportModel;
import de.actonic.gdpr.shared.datacleaner.model.DCIgnoreModel;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DCIgnoreManager
implements IDCIgnoreManager {
    private final DCIgnoreDao dcIgnoreDao;

    public DCIgnoreManager(DCIgnoreDao dcIgnoreDao) {
        this.dcIgnoreDao = dcIgnoreDao;
    }

    public DCIgnoreModel createIgnoreList(DCIgnoreModel dcIgnoreModel) {
        DCIgnoreEntity entity = this.dcIgnoreDao.createEntity(dcIgnoreModel.getTemplateId(), dcIgnoreModel.getType(), dcIgnoreModel.getValue(), dcIgnoreModel.getDescription());
        return this.entityToModel(entity);
    }

    public List<DCIgnoreModel> getAllIgnoreLists() {
        List<DCIgnoreEntity> entities = this.dcIgnoreDao.getAllEntities();
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public DCIgnoreModel updateIgnoreList(DCIgnoreModel dcIgnoreModel) {
        DCIgnoreEntity entity = this.dcIgnoreDao.updateEntity(dcIgnoreModel.getId(), dcIgnoreModel.getTemplateId(), dcIgnoreModel.getType(), dcIgnoreModel.getValue(), dcIgnoreModel.getDescription());
        return this.entityToModel(entity);
    }

    public void deleteIgnoreList(int id) {
        this.dcIgnoreDao.deleteEntity(id);
    }

    public void importIgnoreList(DCIgnoreImportExportModel importModel) {
        this.dcIgnoreDao.importEntities(importModel.getItems());
    }

    public DCIgnoreModel entityToModel(DCIgnoreEntity entity) {
        return DCIgnoreModel.builder().id(Integer.valueOf(entity.getID())).templateId(entity.getTemplateId()).type(entity.getType()).value(entity.getValue()).description(entity.getDescription()).build();
    }
}

