/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.scheduling;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.announcement.model.AnnouncementType;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRBadRequestException;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class CleanAnnouncementRecycleBinJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(CleanAnnouncementRecycleBinJob.class);
    private final AnnouncementService announcementService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager settingsManager;
    private static final Long INTERVAL_CLEAN = 10000L;

    public CleanAnnouncementRecycleBinJob(AnnouncementService announcementService, UserAccessor userAccessor, GDPRSettingsManager settingsManager) {
        this.announcementService = announcementService;
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        ConfluenceUser serviceUser = this.userAccessor.getUserByName(this.settingsManager.getRunTasksFromUser());
        if (serviceUser == null) {
            throw new GDPRBadRequestException("Canceled because there is no service user defined");
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)serviceUser);
        this.announcementService.getAnnouncementsByTypes(new String[]{AnnouncementType.TRASH.getType()}).stream().filter(announcement -> new Date().getTime() - announcement.getModificationDate().getTime() >= INTERVAL_CLEAN).forEach(announcement -> this.announcementService.cleanTrashById(announcement.getId()));
        log.debug(logHelper.stop());
        return JobRunnerResponse.success((String)"Successfully");
    }
}

