/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Entity;
import de.actonic.gdpr.shared.general.manager.IGDPRGroupManager;
import de.actonic.gdpr.shared.general.model.GDPRUserModel;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceISharedGroupManager
implements IGDPRGroupManager {
    private final UserAccessor userAccessor;

    @Autowired
    public ConfluenceISharedGroupManager(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public boolean isUserInGroup(GDPRUserModel sharedUserModel, String group) {
        return this.userAccessor.hasMembership(group, sharedUserModel.getUserName());
    }

    public Collection<String> getGroupNamesForUser(GDPRUserModel sharedUserModel) {
        return this.userAccessor.getGroupNamesForUserName(sharedUserModel.getUserName());
    }

    public Collection<String> getAllGroups() {
        return this.userAccessor.getGroupsAsList().stream().map(Entity::getName).collect(Collectors.toSet());
    }
}

