/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.service.ProfileVisibilityService;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.model.ConfigOwnProfile;
import de.actonic.confluence.gdpr.model.ProfileVisibilityRuleModel;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/profile-visibility")
public class ProfileVisibilityRest {
    private ProfileVisibilityService profileVisibilityService;

    @Autowired
    public ProfileVisibilityRest(ProfileVisibilityService profileVisibilityService) {
        this.profileVisibilityService = profileVisibilityService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getAllRules() {
        List<ProfileVisibilityRuleModel> rules = this.profileVisibilityService.getItems();
        List<String> selectedGroups = this.profileVisibilityService.getTargetGroupNames(rules);
        ImmutableMap resultMap = ImmutableMap.of((Object)"rules", rules, (Object)"selectedGroups", selectedGroups);
        return Response.ok((Object)new Gson().toJson((Object)resultMap)).build();
    }

    @PUT
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response addRule(@FormParam(value="targetGroup") String targetGroup, @FormParam(value="visibleGroups") String visibleGroups) {
        List<ProfileVisibilityRuleModel> items = this.profileVisibilityService.addItem(targetGroup, visibleGroups);
        return Response.ok((Object)new Gson().toJson(items)).build();
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response deleteRule(@FormParam(value="targetGroupName") String targetGroupName) {
        List<ProfileVisibilityRuleModel> items = this.profileVisibilityService.deleteItem(targetGroupName);
        return Response.ok((Object)new Gson().toJson(items)).build();
    }

    @POST
    @Path(value="/state")
    @Produces(value={"application/json"})
    public Response addRule(@FormParam(value="state") String state) {
        this.profileVisibilityService.setState(state);
        return Response.ok().build();
    }

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    public Response addRule() {
        String state = this.profileVisibilityService.getState();
        return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"state", (Object)state))).build();
    }

    @GET
    @Path(value="/my")
    @Produces(value={"application/json"})
    public Response getMyProfileVisibilitySettings() {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        if (applicationUser != null) {
            ConfigOwnProfile configOwnProfile = this.profileVisibilityService.getPersonalProfileVisibilitySettings(applicationUser);
            return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"configOwnProfile", (Object)configOwnProfile))).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/my/show")
    @Produces(value={"application/json"})
    public Response showMyProfile() {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        if (applicationUser != null) {
            this.profileVisibilityService.setUserProfileVisibilitySettings(applicationUser, false);
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/my/hide")
    @Produces(value={"application/json"})
    public Response hideMyProfile() {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        if (applicationUser != null) {
            this.profileVisibilityService.setUserProfileVisibilitySettings(applicationUser, true);
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/announcing")
    @Produces(value={"application/json"})
    public Response getAnnouncementByUsername() {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        if (applicationUser != null) {
            List<AnnouncingModel> announcingModels = this.profileVisibilityService.getAnnouncementByUser(applicationUser);
            return Response.ok((Object)new Gson().toJson(announcingModels)).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/update-answer/{id}/{answer}")
    @Produces(value={"application/json"})
    public Response updateAnswer(@PathParam(value="id") int id, @PathParam(value="answer") String answer, @FormParam(value="questionnaire") String questionnaire, @Context HttpServletRequest httpServletRequest) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        String ip = httpServletRequest.getRemoteAddr();
        if (applicationUser != null) {
            boolean result = this.profileVisibilityService.updateAnswer(id, answer, applicationUser.getKey().getStringValue(), questionnaire, ip);
            if (result) {
                return Response.ok((Object)Response.Status.OK).build();
            }
            return Response.ok((Object)Response.Status.NOT_FOUND).build();
        }
        return Response.serverError().build();
    }
}

