define("actonic-gdpr/announcing/template", ["jquery", "actonic-gdpr/announcing/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/intro"], function ($, Rest, flags, CoreIntro) {

    function Template() {
        var currentAnnouncingId;
        var currentAnnouncingItems;
        var TEMPLATE_PRIVACY_ID = 1;
        var TEMPLATE_COOKIE_ID = 2;
        this.init = function () {

            setupIntro();

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#show-intro").click(function () {
                AJS.dialog2("#help-dialog").hide();
                CoreIntro.start();
            });

            $("#template-privacy-btn").click(function () {
                createAnnouncingTemplate(TEMPLATE_PRIVACY_ID, function (announcingItem) {
                        window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/create-edit-announcing.action?action=edit&id=" + announcingItem.id;
                });
            });

            $("#template-cookie-btn").click(function () {
                createAnnouncingTemplate(TEMPLATE_COOKIE_ID, function (announcingItem) {
                        window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/create-edit-announcing.action?action=edit&id=" + announcingItem.id;
                });
            });

            $("#announcing-form-dialog-cancel-btn").click(function () {
                AJS.dialog2("#announcing-form-dialog").hide();
            });

            $("#confirm-delete-announcing-dialog-ok-btn").click(function () {
                var announcingId = $(this).attr("data-item-id");
                Rest.deleteAnnouncing(announcingId,
                    function () { // success
                        AJS.dialog2("#confirm-delete-announcing-dialog").hide();
                        $("#announcing-table tbody tr[data-announcing-row-id=" + announcingId + "]").remove();
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.delete.info.title"), AJS.I18n.getText("js-announcing.template.rest.delete.info.desc"), "info");
                    },
                    function (error) { // error
                        AJS.dialog2("#confirm-delete-announcing-dialog").hide();
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.delete.error.title"), AJS.I18n.getText("js-announcing.template.rest.delete.error.desc") + " " + JSON.stringify(error.responseText), "error");
                    });
            });
            $("#confirm-delete-announcing-dialog-cancel-btn").click(function () {
                AJS.dialog2("#confirm-delete-announcing-dialog").hide();
            });

            $("#confirm-clear-announcing-dialog-ok-btn").click(function () {
                var announcingId = $(this).attr("data-item-id");
                Rest.clearAnnouncing(announcingId,
                    function (announcingItem) { // success
                        AJS.dialog2("#confirm-clear-announcing-dialog").hide();
                        replaceAnnouncingItem(announcingItem);
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.clear.info.title"), AJS.I18n.getText("js-announcing.template.rest.clear.info.desc"), "info");
                    },
                    function (error) { // error
                        AJS.dialog2("#confirm-clear-announcing-dialog").hide();
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.clear.error.title"), AJS.I18n.getText("js-announcing.template.rest.clear.error.desc") + " " + JSON.stringify(error.responseText), "error");
                    });
            });
            $("#confirm-clear-announcing-dialog-cancel-btn").click(function () {
                AJS.dialog2("#confirm-clear-announcing-dialog").hide();
            });

            eventmachine.addHandler("announcing/items-received", function (announcingItems) {
                displayAnnouncingItems(announcingItems);
            });
        };

        function setupIntro() {
            CoreIntro.init({
                name: "announcing-edit",
                steps: function () {
                    $("#create-announcemet-btn").attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-announcing.intro.step-1"));
                    $("#announcing-table").attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-announcing.intro.step-2"));
                    $("#statistics-btn").attr("data-step", "3").attr("data-intro", AJS.I18n.getText("js-announcing.intro.step-3"));
                }
            });
        }

        function createAnnouncingTemplate(id, successCallback) {
            $("#progress-bar").show();
            Rest.createAnnouncingTemplate(id,
                function (data) { // success
                    $("#progress-bar").hide();
                    //log.debug("Rest.getAnnouncingItems data = " + JSON.stringify(data));
                    successCallback(data);
                },
                function (error) { // error
                    $("#progress-bar").hide();
                    flags.showFlag("Error", AJS.I18n.getText("js-announcing.template.rest.get-announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function replaceAnnouncingItem(announcingItem) {
            var options = {
                id: announcingItem.id,
                name: announcingItem.name,
                status: announcingItem.isActive,
                type: announcingItem.type
            }
            if (announcingItem.extraFields) {
                options.accepted = announcingItem.extraFields.accepted;
                options.declined = announcingItem.extraFields.declined;
            }

            var row = ACTONIC.GDPR.ANNOUNCING.createAnnouncingTableRow(options);
            $("#announcing-table tbody tr[data-announcing-row-id=" + announcingItem.id + "]").replaceWith(row);

            addAnnouncingItemsButtonHandlers();
        }

        function displayAnnouncingItems(announcingItems) {
            currentAnnouncingItems = announcingItems;
            announcingItems.forEach(function (announcingItem) {
                displayAnnouncingItem(announcingItem);
            });
        }

        function displayAnnouncingItem(announcingItem) {
            var options = {
                id: announcingItem.id,
                name: announcingItem.name,
                status: announcingItem.isActive,
                type: announcingItem.type
            }
            if (announcingItem.extraFields) {
                options.accepted = announcingItem.extraFields.accepted;
                options.declined = announcingItem.extraFields.declined;
            }

            var row = ACTONIC.GDPR.ANNOUNCING.createAnnouncingTableRow(options);
            $("#announcing-table tbody").append(row);

            addAnnouncingItemsButtonHandlers();
        }

        function updateStatus(announcingId, isActive) {
            var request = {isActive: isActive};
            Rest.updateStatus(announcingId, request,
                function (announcingItem) { // success
                    replaceAnnouncingItem(announcingItem);
                },
                function (error) { // error
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.update-status.error.title"), AJS.I18n.getText("js-announcing.template.rest.update-status.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function addAnnouncingItemsButtonHandlers() {
            $(".statistics-btn").off("click");
            $(".statistics-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/information-announcing-statistics.action?id=" + announcingId;
            });
            $(".enable-item-btn").off("click");
            $(".enable-item-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                updateStatus(announcingId, true);
            });
            $(".disable-item-btn").off("click");
            $(".disable-item-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                updateStatus(announcingId, false);
            });
            $(".edit-item-btn").off("click");
            $(".edit-item-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/create-edit-announcing.action?action=edit&id=" + announcingId;
            });

            $(".delete-item-btn").off("click");
            $(".delete-item-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                //log.debug("announcingId = " + announcingId);
                $("#confirm-delete-announcing-dialog-ok-btn").attr("data-item-id", announcingId);
                AJS.dialog2("#confirm-delete-announcing-dialog").show();
            });

            $(".clear-item-btn").off("click");
            $(".clear-item-btn").on("click", function () {
                var announcingId = $(this).attr("data-item-id");
                //log.debug("announcingId = " + announcingId);
                $("#confirm-clear-announcing-dialog-ok-btn").attr("data-item-id", announcingId);
                AJS.dialog2("#confirm-clear-announcing-dialog").show();
            });
        }
    }

    return new Template();
});