define("actonic-gdpr/announcing/statistics/filter",
    ["jquery", "actonic-gdpr/announcing/statistics/rest", "actonic-gdpr/announcing/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/intro", "actonic-gdpr/core/picker"],
    function ($, Rest, CoreRest, flags, CoreIntro, Picker) {

    function Filter() {
        var items = [];
        // var ignoreChangeEvents = false;

        this.init = function () {
            setupIntro();

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#show-intro").click(function() {
                AJS.dialog2("#help-dialog").hide();
                CoreIntro.start();
            });

            $("#filter-button").click(function () {
                filterAuditLogs(1);
            });

            $("#sort-by-picker").change(function () {
                filterAuditLogs(1);
            });
            $("#from-date-picker").change(function () {
                filterAuditLogs(1);
            });
            $("#to-date-picker").change(function () {
                filterAuditLogs(1);
            });
            $("#from-date-picker, #to-date-picker").on("keydown keyup", function () {
                var tempDate = $(this).val().replace(/[^0-9-]/g,"");
                $(this).val(tempDate);
            });

            $("#clear-button").click(function () {
                //log.debug("#clear-button.click");
                clearFilters();
            });

            $("#export-button").click(function () {
                var pageNumber = $(this).attr("data-page");
                var request = getRequest(pageNumber);

                Rest.export(request,
                    function (data, requestLink) { // success
                        $("#progress-indicator").hide();
                        window.location = requestLink;
                    },
                    function (error) { // error
                        $("#progress-indicator").hide();
                        console.error(error);
                        if (error.status == 400) {
                            flags.showFlag("Error code 400", error.responseText, "warning");
                        }
                        if (error.status == 403) {
                            flags.showFlag("Error code 403", error.responseText, "warning");
                        }

                    }
                );
            });

            initializeUserPicker();
            initializeAnnouncingPicker(getAnnouncementId());
        };

        function setupIntro() {
            CoreIntro.init({
                name: "announcing-statistics",
                steps: function () {
                    $("#s2id_user-picker").attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-announcing-statistics.intro.step-1"));
                    $("#s2id_announcing-picker").attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-announcing-statistics.intro.step-2"));
                    $(".aui-group").parent().attr("data-step", "3").attr("data-intro", AJS.I18n.getText("js-announcing-statistics.intro.step-3"));
                    $("#filter-group").attr("data-step", "4").attr("data-intro", AJS.I18n.getText("js-announcing-statistics.intro.step-4"));
                }
            });
        }

        function clearFilters() {
            // ignoreChangeEvents = true;
            initializeUserPicker();
            initializeAnnouncingPicker();
            // ignoreChangeEvents = false;

            $("#from-date-picker").val(null);
            $("#to-date-picker").val(null);

            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
            $("#result-click").empty();
        }

        function checkDate(value){
            return value && !value.match(/^[1|2][9|0][0-9]{2}\-(0?[1-9]|1[0-2])\-([1-9]|[0-2][0-9]|3[0-1])$/g);
        }

        function getRequest(currentPage) {
            var selectedUser = $("#user-picker").val();
            var selectedAnnouncing = $("#announcing-picker").val();
            var orderBy = $("#sort-by-picker").val();
            var fromDate = moment($("#from-date-picker").val()).startOf("day").valueOf();
            var toDate = moment($("#to-date-picker").val()).endOf("day").valueOf();
            var valueFromDate = $("#from-date-picker").val();
            var valueToDate = $("#to-date-picker").val();

            if(checkDate(valueFromDate)) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-example")
                });
                return;
            }

            if(checkDate(valueToDate)) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-example")
                });
                return;
            }

            if (fromDate > toDate) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-before")
                });
                return;
            }

            if (fromDate > moment().endOf("day").valueOf()) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-after")
                });
                return;
            }

            $("#progress-indicator").show();
            var page = currentPage ? currentPage : 1;
            var request = {
                page: page,
                userName: selectedUser,
                announcing: selectedAnnouncing,
                orderBy: orderBy
            }

            if (fromDate) request.fromDate = fromDate;
            if (toDate) request.toDate = toDate;

            return request;
        }

        function filterAuditLogs(currentPage) {
            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
            $("#result-click").empty();
            //$("#export-button").hide();

            var request = getRequest(currentPage);

            //log.debug("filterEvents request = " + JSON.stringify(request));

            items = [];
            var accepted = 0;
            var declined = 0;
            Rest.getFilteredAnnouncingHistory(request,
                function (data) { // success
                    //log.debug("Filter.getIssues response = " + JSON.stringify(response));
                    if (typeof data === 'string') data = JSON.parse(data);

                    //log.debug("Rest.getFilteredAuditLogs currentPage = " + data.page + " ; totalPages = " + data.totalPages);
                    initPagination(data.page, data.totalPages);
                    data.items.forEach(function (item) {
                        items.push(item);
                        if (item.answer == "accepted") accepted++;
                        else if (item.answer == "declined") declined++;
                    });

                    $("#result-click").html("<b>" + AJS.I18n.getText("js-announcing-statistics.filter.result-click.total") + ":</b> " + items.length + " | <b>" + AJS.I18n.getText("js-announcing-statistics.filter.result-click.accepted") +  ":</b> " + accepted + " | <b>" + AJS.I18n.getText("js-announcing-statistics.filter.result-click.declined") + ":</b> " + declined);

                    onSearchEnd();
                },
                function (error) { // error
                    log.error(error);
                    if (error.status == 400) {
                        flags.showFlag(AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.error-code.title") + " 400", error.responseText, "warning");
                    }
                    if (error.status == 403) {
                        flags.showFlag(AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.error-code.title") + " 403", error.responseText, "warning");
                    }

                    onSearchEnd();
                });
        }

        function onSearchEnd() {
            //log.debug("onSearchEnd items = " + JSON.stringify(items));
            $("#progress-indicator").hide();
            //$("#export-button").show();

            items.forEach(function (item) {
                //log.debug("item= " + JSON.stringify(item));
                var wellFormatDate = moment(item.timeStamp).format("MMMM Do YYYY, h:mm:ss a");

                //log.debug("event.author = " + event.author);
                var tr = ACTONIC.GDPR.STATISTICS.createHistoryTableRow({
                    name: item.name,
                    user: item.user,
                    date: wellFormatDate,
                    ip: item.ip,
                    result: item.answer,
                    response: item.response
                });

                $("#result-table tbody").append(tr);
            });
        }

        function initPagination(currentPage, totalPages) {
            $("#pagination-container").empty();

            for (i = 1; i <= totalPages; i++) {
                var badge = $("<aui-badge/>").attr("data-page", i).text(i);
                if (currentPage == i) $(badge).addClass("aui-badge-primary");

                $("#pagination-container").append(badge);
            }

            $("#pagination-container aui-badge").off("click");
            $("#pagination-container aui-badge").on("click", function () {
                var pageNumber = $(this).attr("data-page");
                filterAuditLogs(pageNumber);
            });
        }

        function initializeUserPicker() {
            var parent = $("#user-picker").parent();
            $("#user-picker").remove();
            $("#s2id_user-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"user-picker\">");

            Picker.initializeUserPicker("user-picker", false, null, true);

            /*AJS.$("#user-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-announcing-statistics.filter.placeholder.select-user"),
                allowClear: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/users",
                    data: function (term) {
                        return {
                            query: term,
                            maxResults: 100
                        };
                    },
                    results: function (data) {
                        //var users = data.users;
                        var results = [];
                        $.each(data, function (index, item) {
                            results.push({id: item.id, text: item.text});
                        });
                        return {
                            results: results
                        };
                    }
                }
            });*/

            $("#user-picker").off("change");
            $("#user-picker").on("change", function () {
                // if (!ignoreChangeEvents) {
                //     $("#announcing-picker").select2("disable");
                //     $("#s2id_announcing-picker a.select2-choice").addClass("disabled-picker");
                // }
                filterAuditLogs(1);
            });
        }

        function initializeAnnouncingPicker(announcementId) {
            var parent = $("#announcing-picker").parent();
            $("#announcing-picker").remove();
            $("#s2id_announcing-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"announcing-picker\">");

            AJS.$("#announcing-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-announcing-statistics.filter.placeholder.select-announcing"),
                allowClear: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    async: false,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing",
                    data: function (term) {
                        return {
                            query: term
                        };
                    },
                    results: function (data) {
                        var results = [];
                        $.each(data, function (index, item) {
                            //console.log(item.id + ":" + item.name);
                            results.push({id: item.id, text: item.name});
                        });
                        return {
                            results: results
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (announcementId) {
                        CoreRest.getAnnouncing(announcementId,
                            function (data) { // success
                                //log.debug("Rest.getRule data = " + JSON.stringify(data));
                                if (data)
                                    callback({id: data.id, text: data.name});
                            },
                            function (error) {
                                log.error("Rest.getRule error = " + JSON.stringify(error));
                            }
                        );
                    }
                },
                formatResult: function (item) { return item.text; },
                formatSelection: function (item) { return item.text; }
            });

            $("#announcing-picker").off("change");
            $("#announcing-picker").on("change", function () {
                // if (!ignoreChangeEvents) {
                //     $("#user-picker").select2("disable");
                //     $("#s2id_user-picker a.select2-choice").addClass("disabled-picker");
                // }
                filterAuditLogs(1);
            });

            if (announcementId)
                $("#announcing-picker").auiSelect2('val', announcementId).trigger("change");
        }

        function getAnnouncementId() {
            var url = new URL(window.location.href);
            return url.searchParams.get("id");
        }
    }

    return new Filter();
});
