define("actonic-gdpr/access-statistics/filter",
    ["jquery","actonic-gdpr/access-statistics/download", "actonic-gdpr/access-statistics/intro", "actonic-gdpr/access-statistics/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/picker"],
    function ($, Download, Intro, Rest, flags, Picker) {

    function Filter() {
        var ignoreChangeEvents = false;
        var items = [];
        var request;

        this.init = function () {
            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#show-intro").click(function() {
                AJS.dialog2("#help-dialog").hide();
                Intro.showIntro();
            });

            $("#export-button").click(function() {
                if($("#user-picker").val() || $("#space-picker").val()) { // check if any filter param selected
                    Rest.getAll(request,
                        function (data, requestLink) { // success
                            window.location = requestLink;
                        },
                        function (error) { // error
                            log.error(error);
                            if (error.status == 400) {
                                flags.showFlag("Error code 400", error.responseText, "warning");
                            }
                            if (error.status == 403) {
                                flags.showFlag("Error code 403", error.responseText, "warning");
                            }

                        }
                    );
                } else {
                    flags.showFlag("Warning!", "Your filter parameters are empty.", "warning");
                }
            });

            $("#filter-button").click(function () {
                filterAuditLogs(1);
            });

            $("#from-date-picker").change(function () {
                filterAuditLogs(1);
            });

            $("#to-date-picker").change(function () {
                filterAuditLogs(1);
            });

            $("#sort-by-picker").change(function () {
                filterAuditLogs(1);
            });

            $("#from-date-picker, #to-date-picker").on("keydown keyup", function () {
                var tempDate = $(this).val().replace(/[^0-9-]/g,"");
                $(this).val(tempDate);
            });

            $("#clear-button").click(function () {
                clearFilters();
            });

            initializeUserPicker();
            initializePagePicker();
            initializeSpacePicker();
        };

        function clearFilters() {
            ignoreChangeEvents = true;
            initializeUserPicker();
            initializePagePicker();
            initializeSpacePicker();
            ignoreChangeEvents = false;

            $("#from-date-picker").val(null);
            $("#to-date-picker").val(null);

            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
            $("#export-button").hide();
        }

        function checkDate(value){
            return value && !value.match(/^[1|2][9|0][0-9]{2}\-(0?[1-9]|1[0-2])\-([1-9]|[0-2][0-9]|3[0-1])$/g);
        }

        function filterAuditLogs(currentPage) {
            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
            $("#export-button").hide();

            var selectedUser = $("#user-picker").val();
            var pageId = $("#page-picker").val();
            var selectedSpace = $("#space-picker").val();
            var orderBy = $("#sort-by-picker").val();

            if (!selectedUser && !pageId && !selectedSpace) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-access-filter.flags.warning.select-user-space-issue")
                });
                return;
            }

            var fromDate = moment($("#from-date-picker").val()).startOf("day").valueOf();
            var toDate = moment($("#to-date-picker").val()).endOf("day").valueOf();
            var valueFromDate = $("#from-date-picker").val();
            var valueToDate = $("#to-date-picker").val();

            if(checkDate(valueFromDate)) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-example")
                });
                return;
            }

            if(checkDate(valueToDate)) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-announcing-statistics.filter.flag.warning.date-example")
                });
                return;
            }

            if (fromDate > toDate) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-access-filter.flags.warning.date-before")
                });
                return;
            }

            if (fromDate > moment().endOf("day").valueOf()) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-access-filter.flags.warning.date-after")
                });
                return;
            }

            $("#progress-indicator").show();
            var page = currentPage ? currentPage : 1;
            request = {
                page: page,
                userName: selectedUser,
                pageId: pageId,
                spaceKey: selectedSpace,
                orderBy: orderBy
            };

            if (fromDate) request.fromDate = fromDate;
            if (toDate) request.toDate = toDate;

            items = [];
            Rest.filter(request,
                function (data) { // success
                    //log.debug(" Rest.filter  data = " + JSON.stringify(data));
                    if (typeof data === 'string') data = JSON.parse(data);

                    if (data.items.length > 0) {
                        $("#export-button").show();
                    } else {
                        $("#export-button").hide();
                    }

                    //log.debug("Rest.getFilteredAuditLogs currentPage = " + data.page + " ; totalPages = " + data.totalPages);
                    initPagination(data.page, data.totalPages);

                    var receivedEvents = data.items;
                    receivedEvents.forEach(function (event) {
                        items.push(event);
                    });

                    onSearchEnd();
                },
                function (error) { // error
                    log.error(error);
                    if (error.status == 400) {
                        flags.showFlag("Error code 400", error.responseText, "warning");
                    }
                    if (error.status == 403) {
                        flags.showFlag("Error code 403", error.responseText, "warning");
                    }

                    onSearchEnd();
                });
        }

        function onSearchEnd() {
            //log.debug("EDN!!!!!!");
            //log.debug("onSearchEnd items = " + JSON.stringify(items));
            $("#progress-indicator").hide();

            items.forEach(function (item) {
                var formattedDate = moment(item.timeStamp).format("MMMM Do YYYY, h:mm:ss a");

                //log.debug("event.author = " + event.author);
                var tr = ACTONIC.GDPR.ACCESS.createTableRow({
                    date: formattedDate,
                    space: item.space,
                    page: item.page,
                    user: item.userName,
                    ip: item.ipAddress,
                    type: item.type
                });

                $("#result-table tbody").append(tr);
            });
        }

        function initPagination(currentPage, totalPages) {
            $("#pagination-container").empty();

            for (i = 1; i <= totalPages; i++) {
                var badge = $("<aui-badge/>").attr("data-page", i).text(i);
                // log.debug("i = " + JSON.stringify(i) + " currentPage = " + JSON.stringify(currentPage));
                if (currentPage == i) $(badge).addClass("aui-badge-primary");

                $("#pagination-container").append(badge);
            }

            $("#pagination-container aui-badge").off("click");
            $("#pagination-container aui-badge").on("click", function () {
                var pageNumber = $(this).attr("data-page");
                filterAuditLogs(pageNumber);
            });
        }

        function initializePagePicker() {
            var parent = $("#page-picker").parent();
            $("#page-picker").remove();
            $("#s2id_page-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"page-picker\">");


            AJS.$("#page-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-access-filter.placeholder.select-page"),
                allowClear: true,
                //minimumInputLength: 2,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/pages",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term,
                            spaceKey: $("#space-picker").val()
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text
                                }
                            })
                        };
                    }
                }
            });

            $("#page-picker").off("change");
            $("#page-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#user-picker").select2("disable");
                    $("#s2id_user-picker a.select2-choice").addClass("disabled-picker");

                    $("#space-picker").select2("disable");
                    $("#s2id_space-picker a.select2-choice").addClass("disabled-picker");
                }
                filterAuditLogs(1);
            });

            $("#page-picker").select2("disable");
            $("#s2id_page-picker a.select2-choice").addClass("disabled-picker");
        }

        function initializeUserPicker() {
            var parent = $("#user-picker").parent();
            $("#user-picker").remove();
            $("#s2id_user-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"user-picker\">");

            Picker.initializeUserPicker("user-picker");

            /*AJS.$("#user-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-access-filter.placeholder.select-user"),
                allowClear: true,
                minimumInputLength: 2,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/users",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                }
            });*/

            $("#user-picker").off("change");
            $("#user-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#page-picker").select2("disable");
                    $("#s2id_page-picker a.select2-choice").addClass("disabled-picker");

                    $("#space-picker").select2("disable");
                    $("#s2id_space-picker a.select2-choice").addClass("disabled-picker");
                }
                filterAuditLogs(1);
            });
        }

        function initializeSpacePicker() {
            var parent = $("#space-picker").parent();
            $("#space-picker").remove();
            $("#s2id_space-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"space-picker\">");

            AJS.$("#space-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-access-filter.placeholder.select-space"),
                allowClear: true,
                //minimumInputLength: 2,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/spaces",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                }
            });

            $("#space-picker").off("change");
            $("#space-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#page-picker").select2("enable");
                    $("#s2id_page-picker a.select2-choice").removeClass("disabled-picker");

                    $("#user-picker").select2("disable");
                    $("#s2id_user-picker a.select2-choice").addClass("disabled-picker");
                }
                filterAuditLogs(1);
            });
        }
    }

    return new Filter();
});
