define("gdpr/data-cleaner/cql-picker", ["jquery", "gdpr/core/aui-picker", "actonic-gdpr/core/picker"],
    function ($, Picker, UserPicker) {

        function DataCleanerCqlPickerFunction() {

            this.init = function (cqlSelector, params) {
                $("#main").append(ACTONIC.GDPR.DATACLEANER.EDIT.showCqlDialog(params));
                AJS.dialog2("#cql-dialog").show();

                // TODO init pickers with values
                UserPicker.initializeUserPicker("cql-contributor-picker", true, $("#cql-contributor-picker").val());
                Picker.initSpacePicker("cql-space-picker", true, $("#cql-space-picker").val());
                Picker.initPagePicker("cql-page-picker", true, $("#cql-page-picker").val());
                Picker.initLabelPicker("cql-label-picker", true, $("#cql-label-picker").val());
                Picker.initDatePicker("cql-date-start-picker", $("#cql-date-start-picker").val());
                Picker.initDatePicker("cql-date-end-picker", $("#cql-date-end-picker").val());

                $("#cql-dialog #save-button").on("click", function (e) {
                    var cqlType = $(".radio[name='cql-type']:checked").val();
                    $("#cql-type").val(cqlType);

                    if (cqlType === "cql") {
                        var cql = $("#cql-field").val();
                        $(cqlSelector).val(cql);

                        if (cql && cql !== "") {
                            $(cqlSelector).text(cql);
                            $(cqlSelector).attr("original-title", cql);
                        } else {
                            $(cqlSelector).text("No parameters defined.");
                            $(cqlSelector).attr("original-title", "No parameters defined.");
                        }
                    }
                    if (cqlType === "params") {
                        var params = {};
                        // if ($("#cql-page-picker").val() !== "") params["page"] = $("#cql-page-picker").val();
                        if ($("#cql-space-picker").val() !== "") params["space"] = $("#cql-space-picker").val();
                        if ($("#cql-contributor-picker").val() !== "") params["contributor"] = $("#cql-contributor-picker").val();
                        if ($("#cql-label-picker").val() !== "") params["label"] = $("#cql-label-picker").val();
                        if ($("#cql-date-start-picker").val() !== "") params["startDate"] = $("#cql-date-start-picker").val();
                        if ($("#cql-date-end-picker").val() !== "") params["endDate"] = $("#cql-date-end-picker").val();
                        if (params["startDate"] || params["endDate"]) params["rangeType"] = $(".radio[name='cql-range-type']:checked").val();

                        var json = JSON.stringify(params);
                        var jsonWithoutBrackets = "No parameters defined.";
                        var trimmed = "No parameters defined.";
                        if (json && json.length > 2) {
                            jsonWithoutBrackets = json.substring(1, json.length - 1);
                            trimmed = json.length > 50 ? json.substring(1, 50) + "..." : json.substring(1, json.length - 1);
                        }
                        $(cqlSelector).val(json);
                        $(cqlSelector).text(trimmed);
                        $(cqlSelector).attr("original-title", jsonWithoutBrackets);
                    }
                    $("#cql-dialog #close-button").click();
                });

                $("#cql-dialog #close-button").on("click", function (e) {
                    e.preventDefault();
                    AJS.dialog2("#cql-dialog").hide();

                    $("#cql-dialog #save-button").off("click");
                    $("#cql-dialog #close-button").off("click");
                    $("#cql-type-button-cql").off("click");
                    $("#cql-type-button-picker").off("click");
                });

                $("#cql-type-button-cql").on("click", function () {
                    $("#type-cql-container").show();
                    $("#type-picker-container").hide();
                });

                $("#cql-type-button-picker").on("click", function () {
                    $("#type-cql-container").hide();
                    $("#type-picker-container").show();
                });
            }
        }

        return new DataCleanerCqlPickerFunction();
    })
