require(["jquery", "gdpr/core/log", "actonic-gdpr/core/flags", "actonic-gdpr/core/intro", "actonic-gdpr/domReady",
        "actonic-gdpr/core/tippy", "gdpr/core/element-highlighter", "gdpr/core/utils",
        "gdpr/data-cleaner/result/rest", "gdpr/data-cleaner/rest", "gdpr/data-cleaner/tasks/rest"],
    function ($, log, flags, CoreIntro,
              domReady, Tippy, coreHighlighter, coreUtils,
              resultRest, dataCleanerRest, taskRest) {
        domReady(function () {
            new DataCleanerResults().init();
        });

        var TASK_STATUS = {
            UNDEFINED: -1,
            NOT_STARTED: 0,
            IN_PROGRESS: 1,
            ABORTED: 2,
            FINISHED: 3,
            FAILED: 5
        };

        var TASK_TYPE = {
            UNDEFINED: -1,
            SEARCH: 0,
            ANONYMIZE: 1
        };

        var RESULT_STATUS = {
            UNDEFINED: -1,
            FOUND: 0,
            ANONYMIZED: 1,
            SKIPPED: 2,
            FAILED: 3
        };

        var pageIndex = {
            prev: 0,
            next: 2,
            current: 1
        };

        var totalPages = 1;

        function DataCleanerResults() {
            var currentTemplateId = coreUtils.getCurrentUrlParameterByName("templateId");
            var currentTaskId = coreUtils.getCurrentUrlParameterByName("taskId");
            var currentTaskData;
            var previousStatus = null;

            if (currentTemplateId == -1) {
                $("#go-to-edit-template").remove();
                $("#start-search-task-btn").remove();
                $("#start-anonymization-task-btn").remove();
                $("#template-details-trigger").remove();
                $("#template-name-wrapper").html(AJS.I18n.getText("js-data-clean.template.uat.text.name"));
            }

            this.init = function () {
                //log.debug("templateId = " + JSON.stringify(currentTemplateId));
                //log.debug("taskId = " + JSON.stringify(currentTaskId));

                $("#content").append(ACTONIC.GDPR.DATACLEANER.MODALS.confirmationAnonymization());

                getLastExecutions(function () {
                    if (currentTaskId) {
                        initFilterPickers();
                        filterResults(1);

                        $("#last-executions-trigger").click();

                        $(".history-nav-items").scrollLeft($(".history-nav-item-active").position().left);
                    } else {
                        $(".history-nav-items").scrollLeft($(".history-nav-items").get(0).scrollWidth);
                        $("#data-cleaner-select-logs").show();
                    }
                });

                loadTemplateData();

                $("#start-search-task-btn").click(startSearchBtnHandler);
                // $("#start-anonymization-task-btn").click(startAnonymizationBtnHandler);
                $("#start-anonymization-task-btn").click(function () {
                    AJS.dialog2("#confirm-anonymization-dialog").show();
                    $("#current-anonymization-name").html($("#template-name").html());
                });
                $("#confirm-anonymization-confirm-btn").on("click", function (event) {
                    event.preventDefault();
                    AJS.dialog2("#confirm-anonymization-dialog").hide();

                    startAnonymizationBtnHandler();
                });
                $("#confirm-anonymization-cancel-btn").on("click", function (event) {
                    event.preventDefault();
                    AJS.dialog2("#confirm-anonymization-dialog").hide();
                });
                $("#stop-task-btn").click(stopTaskBtnHandler);

                $("#go-to-edit-template").click(function () {
                    window.location = AJS.contextPath() + "/admin/actonic-gdpr/edit-data-cleaner-template.action?action=edit&id=" + currentTemplateId;
                });

                $("#filter-results").on("click", function (event) {
                    event.preventDefault();
                    filterResults(1);
                });

                $("#clear-filter").on("click", function (event) {
                    event.preventDefault();
                    clearFilters();
                });

                $("#btn-indicated-page").off("click");
                $("#btn-indicated-page").on("click", function() {
                    var indicatedPage = parseInt($("#txt-indicated-page").val().trim(), 10);
                    if (indicatedPage != pageIndex.current) {
                        if (indicatedPage > 0 && indicatedPage <= totalPages) {
                            pageIndex.prev = indicatedPage - 1;
                            pageIndex.next = indicatedPage + 1;
                            pageIndex.current = indicatedPage;
                            filterResults(indicatedPage);
                        } else
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.rp.wrong-page"));
                    } else
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rp.already-this-page"));
                });

                // License.check();

                window.onbeforeunload = null; // prevent 'Changes you made may not be saved' message
            };

            function initFilterPickers() {
                // project picker
                var parent = $("#project-picker").parent();
                $("#project-picker").remove();
                $("#s2id_project-picker").remove();
                $(parent).append("<input type=\"text\" class=\"select\" id=\"project-picker\">");

                $.ajax({
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/projects/" + currentTaskId,
                    type: "GET",
                    cache: false,
                    async: true,
                    success: function (data) {
                        var selectData = [];
                        $.map(data, function (value, key) {
                            selectData.push({id: key, text: value});
                        })

                        AJS.$("#project-picker").auiSelect2({
                            placeholder: AJS.I18n.getText("js-result-page.select-space.placeholder.label"),
                            allowClear: true,
                            multiple: true,
                            data: selectData
                        })
                    }
                })

                $("#project-picker").off("change");
                $("#project-picker").on("change", function () {
                    filterResults(1);
                });

                // object picker
                var parent = $("#object-picker").parent();
                $("#object-picker").remove();
                $("#s2id_object-picker").remove();
                $(parent).append("<input type=\"text\" class=\"select\" id=\"object-picker\">");

                AJS.$("#object-picker").auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rp.text.select-objects"),
                    allowClear: true,
                    multiple: true,
                    data: [
                        {
                            id: "title",
                            text: AJS.I18n.getText("js-data-clean.rp.text.title")
                        },
                        {
                            id: "body",
                            text: AJS.I18n.getText("js-data-clean.rp.text.body")
                        },
                        {
                            id: "comment",
                            text: AJS.I18n.getText("js-data-clean.rp.text.comment")
                        },
                        {
                            id: "author",
                            text: AJS.I18n.getText("js-data-clean.rp.text.author")
                        },
                        {
                            id: "comment-author",
                            text: AJS.I18n.getText("js-data-clean.rp.text.comment-author")
                        },
                        {
                            id: "attach-author",
                            text: AJS.I18n.getText("js-data-clean.rp.text.attach-author")
                        }
                    ]
                });
                $("#object-picker").off("change");
                $("#object-picker").on("change", function () {
                    filterResults(1);
                });


                // status picker
                var parent = $("#status-picker").parent();
                $("#status-picker").remove();
                $("#s2id_status-picker").remove();
                $(parent).append("<input type=\"text\" class=\"select\" id=\"status-picker\" autocomplete='off'>");

                AJS.$("#status-picker").auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rp.text.select-statuses"),
                    allowClear: true,
                    multiple: true,
                    data: [
                        // {
                        //     id: -1,
                        //     text: AJS.I18n.getText("js-data-clean.rp.text.undefined")
                        // },
                        {
                            id: 0,
                            text: AJS.I18n.getText("js-data-clean.rp.text.found")
                        },
                        {
                            id: 1,
                            text: AJS.I18n.getText("js-data-clean.rp.text.annonymized")
                        },
                        // {
                        //     id: 2,
                        //     text: AJS.I18n.getText("js-data-clean.rp.text.skipped")
                        // },
                        {
                            id: 3,
                            text: AJS.I18n.getText("js-data-clean.rp.text.failed")
                        }
                    ]
                });
                $("#status-picker").off("change");
                $("#status-picker").on("change", function () {
                    filterResults(1);
                });

                // rule picker
                var parent = $("#rule-picker").parent();
                $("#rule-picker").remove();
                $("#s2id_rule-picker").remove();
                $(parent).append("<input type=\"text\" class=\"select\" id=\"rule-picker\">");

                var ruleArray = [];
                $.each(currentTaskData.meta.rules, function (index, item) {
                    ruleArray.push({id: index, text: item});
                });

                AJS.$("#rule-picker").auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rp.text.select-rules"),
                    allowClear: true,
                    multiple: true,
                    data: ruleArray
                });
                $("#rule-picker").off("change");
                $("#rule-picker").on("change", function () {
                    filterResults(1);
                });

                // sort-by picker
                var parent = $("#sort-by-date").parent();
                $("#sort-by-date").remove();
                $("#s2id_sort-by-date").remove();
                $(parent).append("<input type='text' class='select' id='sort-by-date'>");

                AJS.$("#sort-by-date").auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rp.text.select-sort-by"),
                    allowClear: true,
                    minimumResultsForSearch: -1,
                    data: [
                        {
                            id: 0,
                            text: AJS.I18n.getText("js-data-clean.rp.text.found-time")
                        },
                        {
                            id: 1,
                            text: AJS.I18n.getText("js-data-clean.rp.text.issue-date-desc")
                        },
                        {
                            id: 2,
                            text: AJS.I18n.getText("js-data-clean.rp.text.issue-date-asc")
                        }
                    ]
                }).auiSelect2("val", 0);

                $("#sort-by-date").off("change");
                $("#sort-by-date").on("change", function () {
                    filterResults(1);
                });
            }

            function clearFilters() {
                initFilterPickers();
                filterResults(1);
            }

            function startSearchBtnHandler() {
                $("#start-search-task-btn").hide();
                $("#start-anonymization-task-btn").hide();
                $("#go-to-edit-template").hide();
                $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-complete'>" +
                    AJS.I18n.getText('js-data-clean.rp.text.status.in-progress') +
                    "</span>");
                $("#stop-task-btn").show();

                //log.debug("startSearchBtnHandler");
                var request = {
                    templateId: currentTemplateId,
                    type: 0
                };
                taskRest.createTask(request, function (data) {
                    previousStatus = -1;
                }, function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(xhr.responseText);
                });
            }

            function startAnonymizationBtnHandler() {
                $("#start-search-task-btn").hide();
                $("#start-anonymization-task-btn").hide();
                $("#go-to-edit-template").hide();
                $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-complete'>" +
                    AJS.I18n.getText('js-data-clean.rp.text.status.in-progress') +
                    "</span>");
                $("#stop-task-btn").show();

                //log.debug("startAnonymizationBtnHandler");
                var request = {
                    templateId: currentTemplateId,
                    type: 1
                };
                taskRest.createTask(request, function (data) {
                    previousStatus = -1;
                }, function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(xhr.responseText);
                });
            }

            function stopTaskBtnHandler() {
                //log.debug("stopTaskBtnHandler");
                taskRest.cancelTask(currentTemplateId,
                    function (data) {
                        $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-complete'>" +
                            AJS.I18n.getText('js-data-clean.rp.text.status.none') +
                            "</span>");
                    },
                    function (xhr) {
                        log.error(xhr);
                    }
                )
            }

            function loadTemplateData() {
                dataCleanerRest.getById(currentTemplateId,
                    function (templateData) {
                        //log.debug(templateData);
                        // TODO other params
                        $("#template-name").text(templateData.name);
                        $("#template-id").text(templateData.id);
                        $("#template-creation-date").text(templateData.creationDate);
                        $("#template-last-modification-date").text(templateData.lastModificationDate);
                        $("#template-creator").text(templateData.creator);
                        $("#template-last-modifier").text(templateData.lastModifier);

                        if (templateData.task &&
                            (templateData.task.status == TASK_STATUS.IN_PROGRESS || templateData.task.status == TASK_STATUS.NOT_STARTED)) {
                            $("#start-search-task-btn").hide();
                            $("#start-anonymization-task-btn").hide();
                            $("#stop-task-btn").show();

                            $("#go-to-edit-template").hide();

                            if (templateData.task.status == TASK_STATUS.IN_PROGRESS) {
                                $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-complete'>" +
                                    AJS.I18n.getText('js-data-clean.rp.text.status.in-progress') +
                                    "</span>");
                                getLastExecutions(null);
                            } else if (templateData.task.status == TASK_STATUS.NOT_STARTED) {
                                $("#task-status").html(AJS.I18n.getText("js-data-clean.rp.text.status.queued"));
                                getLastExecutions(null);
                            }
                        } else {
                            $("#start-search-task-btn").show();
                            $("#start-anonymization-task-btn").show();
                            $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle'>" +
                                AJS.I18n.getText('js-data-clean.rp.text.status.none') +
                                "</span>");
                            $("#stop-task-btn").hide();

                            $("#task-status").html("<span class='aui-lozenge aui-lozenge-subtle'>" +
                                AJS.I18n.getText("js-data-clean.rp.text.status.none") +
                                "</span>");
                            $("#go-to-edit-template").show();
                        }
                        if (templateData.task && previousStatus != null)
                            if (previousStatus != templateData.task.status) {
                                getLastExecutions(null);
                                previousStatus = null;
                            }
                        setTimeout(loadTemplateData, 3000);
                    }, function (xhr) {
                        log.error(xhr);
                    })
            }

            function getHistoricalTaskTitle(historicalTask) {
                var wrapperTitle = "";
                if (TASK_TYPE.UNDEFINED == historicalTask.taskType)
                    wrapperTitle = AJS.I18n.getText("js-data-clean.rp.text.unknown");
                if (TASK_TYPE.ANONYMIZE == historicalTask.taskType)
                    wrapperTitle = AJS.I18n.getText("js-data-clean.rp.text.anonymization");
                if (TASK_TYPE.SEARCH == historicalTask.taskType)
                    wrapperTitle = AJS.I18n.getText("js-data-clean.rp.text.search");

                if (TASK_STATUS.UNDEFINED == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.lower-unknown");
                if (TASK_STATUS.ABORTED == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.canceled");
                if (TASK_STATUS.FAILED == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.failed");
                if (TASK_STATUS.FINISHED == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.finished");
                if (TASK_STATUS.IN_PROGRESS == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.in-progress");
                if (TASK_STATUS.NOT_STARTED == historicalTask.status)
                    wrapperTitle += " " + AJS.I18n.getText("js-data-clean.rp.text.queued");

                return wrapperTitle;
            }

            function getResultStatus(historicalTask) {
                var status = "";
                if (RESULT_STATUS.FOUND == historicalTask.status)
                    status = "<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-inprogress'>" + AJS.I18n.getText("js-data-clean.rp.text.found") + "</span>";
                if (RESULT_STATUS.ANONYMIZED == historicalTask.status)
                    status = "<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-success'>" + AJS.I18n.getText("js-data-clean.rp.text.annonymized") + "</span>";
                if (RESULT_STATUS.SKIPPED == historicalTask.status)
                    status = "<span class='aui-lozenge aui-lozenge-subtle'>" + AJS.I18n.getText("js-data-clean.rp.text.skipped") + "</span>";
                if (RESULT_STATUS.FAILED == historicalTask.status)
                    status = "<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-removed'>" + AJS.I18n.getText("js-data-clean.rp.text.failed") + "</span>";
                if (RESULT_STATUS.UNDEFINED == historicalTask.status)
                    status = "<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-removed'>" + AJS.I18n.getText("js-data-clean.rp.text.undefined") + "</span>";
                return status;
            }

            function getBackgroundColorClass(historicalTask) {
                var colorClass = "";

                if (TASK_STATUS.UNDEFINED == historicalTask.status) colorClass = "background-color-gray";
                if (TASK_STATUS.ABORTED == historicalTask.status || TASK_STATUS.FAILED == historicalTask.status) colorClass = "background-color-canceled";
                if (TASK_STATUS.FINISHED == historicalTask.status) colorClass = "background-color-finished";
                if (TASK_STATUS.IN_PROGRESS == historicalTask.status) colorClass = "background-color-blue";
                if (TASK_STATUS.NOT_STARTED == historicalTask.status) colorClass = "";

                return colorClass;
            }

            function getLastExecutions(successCallback) {
                resultRest.getLastExecutions(currentTemplateId,
                    function (data) {
                        //log.debug(data);
                        if (data && (data.historicalTasks || data.activeTask.value)) {
                            if (data.historicalTasks) {
                                $(".history-nav-items").empty();
                                if (data.historicalTasks.length) {
                                    data.historicalTasks.forEach(function (historicalTask) {
                                        var wrapperTitle = getHistoricalTaskTitle(historicalTask);

                                        $(".history-nav-items").append(ACTONIC.GDPR.DATACLEANER.RESULTS.renderHistoricalTask({
                                            title: wrapperTitle,
                                            historicalTask: historicalTask,
                                            currentTaskId: currentTaskId,
                                            itemBackgroundColorClass: getBackgroundColorClass(historicalTask)
                                        }));
                                        if (historicalTask.id == currentTaskId) currentTaskData = historicalTask;
                                    });
                                } else {
                                    $("#data-cleaner-no-history-record-found").show();
                                }

                                $(".history-nav-item").off("click");
                                $(".history-nav-item").on("click", function () {
                                    var clickedTemplateId = $(this).attr("data-task-id");
                                    window.location = "data-cleaner-results.action?templateId=" + currentTemplateId + "&taskId=" + clickedTemplateId;
                                });
                            }
                            if (data.activeTask.value) {
                                //log.debug(data.activeTask);
                                var wrapperTitle = getHistoricalTaskTitle(data.activeTask.value);
                                $(".history-nav-items").append(ACTONIC.GDPR.DATACLEANER.RESULTS.renderActiveTask({
                                    title: wrapperTitle,
                                    activeTask: data.activeTask.value,
                                    itemBackgroundColorClass: getBackgroundColorClass(data.activeTask.value)
                                }));
                                previousStatus = data.activeTask.value.status;
                                $(".history-nav-items").scrollLeft($(".history-nav-items").get(0).scrollWidth);
                            }
                            if (typeof successCallback === "function") successCallback();
                        }
                    },
                    function (error) {

                    });
            }

            function initPagination(currentPage, totalPages) {
                var isContinue = totalPages > 0 ? true : false;
                $("#pagination-container").empty();

                if (isContinue) {
                    var count;
                    var badge;

                    badge = $("<aui-badge/>").attr("data-page", 1).text(AJS.I18n.getText("js-result-page.first-btn"));
                    if (totalPages === 1 || currentPage === 1) {
                        $(badge).addClass("custom-badge-disable");
                    }
                    $("#pagination-container").append(badge);

                    badge = $("<aui-badge/>").attr("data-page", pageIndex.prev).text(AJS.I18n.getText("js-result-page.prev-btn"));
                    if (totalPages === 1 || currentPage === 1) {
                        $(badge).addClass("custom-badge-disable");
                    }
                    $("#pagination-container").append(badge);

                    if (currentPage > 3) {
                        badge = $("<aui-badge/>").attr("data-page", -1).text("...");
                        $("#pagination-container").append(badge);
                    }

                    count = (currentPage > 2) ? (currentPage - 2) : 1;

                    while (isContinue) {
                        badge = $("<aui-badge/>").attr("data-page", count).text(count);
                        if (count === currentPage && totalPages !== 1) {
                            $(badge).addClass("aui-badge-primary");
                        } else if (totalPages === 1) {
                            $(badge).addClass("custom-badge-disable");
                        }
                        $("#pagination-container").append(badge);

                        count++;

                        if (count > (currentPage + 2)) {
                            isContinue = false;

                            if (totalPages >= count) {
                                badge = $("<aui-badge/>").attr("data-page", -1).text("...");
                                $("#pagination-container").append(badge);
                            }
                        }

                        if (count > totalPages) {
                            isContinue = false;
                        }
                    }

                    badge = $("<aui-badge/>").attr("data-page", pageIndex.next).text(AJS.I18n.getText("js-result-page.next-btn"));
                    if (totalPages === currentPage) {
                        $(badge).addClass("custom-badge-disable");
                    }
                    $("#pagination-container").append(badge);

                    badge = $("<aui-badge/>").attr("data-page", totalPages).text(AJS.I18n.getText("js-result-page.last-btn"));
                    if (totalPages === currentPage) {
                        $(badge).addClass("custom-badge-disable");
                    }
                    $("#pagination-container").append(badge);

                    if (count > 0) $("#goto-container").show();
                }

                $("#pagination-container aui-badge").off("click");
                $("#pagination-container aui-badge").on("click", function () {
                    var pageNumber = parseInt($(this).attr("data-page"), 10);
                    if (pageNumber != pageIndex.current && pageNumber > 0 && pageNumber <= totalPages) {
                        pageIndex.prev = pageNumber - 1;
                        pageIndex.next = pageNumber + 1;
                        pageIndex.current = pageNumber;
                        filterResults(pageNumber);
                    }
                });
            }

            function convertIfAnonymized(currentString) {
                if (currentString && currentString === "<anonymized>")
                    return currentString.replaceAll("<", "&#60;").replaceAll(">", "&#62;")
                if (!currentString || currentString === "")
                    return "&#60;null&#62;";
                return currentString;
            }

            function filterResults(currentPage) {
                $("#result-table tbody tr").remove();
                $("#pagination-container").empty();
                $("#progress-indicator").show();

                var page = currentPage ? currentPage : 1;
                pageIndex.current = page;

                var request = {
                    taskId: currentTaskId,
                    page: page,
                    project: $("#project-picker").val(),
                    object: $("#object-picker").val(),
                    status: $("#status-picker").val(),
                    rule: $("#rule-picker").val(),
                    sortBy: $("#sort-by-date").val()
                };


                resultRest.getTaskResults(request,
                    function (data) { // success
                        //log.debug(data);
                        //log.debug("Rest.getFilteredAuditLogs currentPage = " + data.page + " ; totalPages = " + data.totalPages);
                        totalPages = data.totalPages;
                        initPagination(data.page, data.totalPages);

                        if (data && data.results && data.results.length) {
                            $("#data-cleaner-no-items-found").hide();

                            // log.debug(JSON.stringify(data.results));

                            data.results.forEach(function (item) {
                                $("#result-table tbody").append(ACTONIC.GDPR.DATACLEANER.RESULTS.newResultRow({
                                    id: item.id,
                                    ruleId: getRuleNameById(item.ruleId),
                                    space: item.space,
                                    ceo: item.ceo,
                                    object: item.object,
                                    affectedContent: convertIfAnonymized(item.data),
                                    status: getResultStatus(item),
                                    baseUrl: AJS.contextPath()
                                }));
                            });

                            $(".anonimyze-row").off("click");
                            $(".anonimyze-row").on("click", function () {
                                var closestRow = $(this).closest("tr");
                                $(closestRow).find("td[data-column-name='status']").html("<span class='aui-icon aui-icon-wait'></span>");

                                var itemId = $(this).attr("data-item-id");
                                var customAnonymizationRequest = {
                                    templateId: currentTemplateId,
                                    itemIds: [itemId]
                                };
                                resultRest.customAnonymization(customAnonymizationRequest,
                                    function (customAnonymizationResults) {
                                        // log.debug(JSON.stringify(customAnonymizationResults));

                                        customAnonymizationResults.forEach(function (item) {
                                            var affectedRow = $("#result-table tr[data-item-id='" + item.id + "']");
                                            $(affectedRow).replaceWith(ACTONIC.GDPR.DATACLEANER.RESULTS.newResultRow({
                                                id: item.id,
                                                ruleId: getRuleNameById(item.ruleId),
                                                space: item.space,
                                                ceo: item.ceo,
                                                object: item.object,
                                                affectedContent: convertIfAnonymized(item.data),
                                                status: getResultStatus(item),
                                                baseUrl: AJS.contextPath()
                                            }));
                                        });
                                    },
                                    function (customAnonymizationError) {
                                        log.debug(JSON.stringify(customAnonymizationError));
                                    });
                            });

                            $("#export-to-csv").show();
                            AJS.$(document).off("click", "#export-to-csv");
                            AJS.$(document).on("click", "#export-to-csv", function () {
                                var spinnerEl = this;
                                if (!spinnerEl.isBusy()) {
                                    spinnerEl.busy();
                                    if (currentTaskId) {
                                        resultRest.getCSVExportTask(request, function (data, filename) {
                                            const blob = new Blob([data], {type: 'text/csv'});
                                            if (window.navigator.msSaveOrOpenBlob) {
                                                window.navigator.msSaveBlob(blob, filename);
                                            } else {
                                                const elem = window.document.createElement('a');
                                                elem.href = window.URL.createObjectURL(blob);
                                                elem.download = filename;
                                                document.body.appendChild(elem);
                                                elem.click();
                                                document.body.removeChild(elem);
                                            }
                                            spinnerEl.idle();
                                        }, function () {
                                            AJS.flag({
                                                type: 'warning',
                                                body: 'Something went wrong. Cannot export data.',
                                                close: 'auto'
                                            })
                                            spinnerEl.idle();
                                        })
                                    } else {
                                        AJS.flag({
                                            type: 'warning',
                                            body: 'Please choose some task firstly',
                                            close: 'auto'
                                        })
                                        spinnerEl.idle();
                                    }
                                }
                            })
                        } else {
                            $("#data-cleaner-no-items-found").show();
                        }

                        $("#progress-indicator").hide();
                    },
                    function (error) { // error
                        log.error(error);
                        if (error.status == 400) {
                            flags.showFlag("Error code 400", error.responseText, "warning");
                        }
                        if (error.status == 403) {
                            flags.showFlag("Error code 403", error.responseText, "warning");
                        }

                        $("#progress-indicator").hide();
                    });
            }

            function getRuleNameById(id) {
                if (currentTaskData && currentTaskData.meta && currentTaskData.meta.rules) {
                    var rules = currentTaskData.meta.rules;
                    return rules[id];
                }
            }
        }

    }
);
