/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.webwork;

import com.atlassian.confluence.setup.BuildInformation;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.service.ActonicLicenseService;
import de.actonic.confluence.gdpr.component.service.ConditionService;
import de.actonic.confluence.gdpr.webwork.ExtendedConfluenceActionSupport;

public class DefaultAction
extends ExtendedConfluenceActionSupport {
    private ActonicLicenseService actonicLicenseService;
    private ConfigurationManager configurationManager;
    private ConditionService conditionService;

    public String execute() throws Exception {
        if (!this.conditionService.shouldDisplay()) {
            return "error";
        }
        this.data.put("rowsPerPage", this.configurationManager.getRowsPerPage());
        this.data.put("isLicenseValid", this.actonicLicenseService.isLicenseValid());
        String version = BuildInformation.INSTANCE.getVersionNumber();
        Integer majorVersion = this.getMajorVersion(version);
        this.data.put("version", majorVersion);
        return "success";
    }

    private Integer getMajorVersion(String version) {
        try {
            String[] parts = version.split("\\.");
            return Integer.parseInt(parts[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setActonicLicenseService(ActonicLicenseService actonicLicenseService) {
        this.actonicLicenseService = actonicLicenseService;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setConditionService(ConditionService conditionService) {
        this.conditionService = conditionService;
    }
}

