require(["actonic-gdpr/core/safe-jquery", "actonic-gdpr/domReady", "actonic-gdpr/core/flags", "actonic-gdpr/global/rest", "actonic-gdpr/core/cookies", "actonic-gdpr/core/utils", "gdpr/core/user-activity"], function ($, domReady, flags, Rest, Cookies, Utils, UserActivity) {
    domReady(function () {
        new Announcements().init();
    });

    var TIMEOUT_SECONDS_BETWEEN_REPETITIONS = 120; // seconds
    var announcementTimeoutRef;
    var GDPR_ANONYMOUS_ANNOUNCING = "gdpr-anonymous-announcing";
    var ANONYMOUS_SEPERATOR = "-";
    var cookieAnnouncings;

    function Announcements() {
        this.init = function () {
            if (window.location.href.indexOf("/actonic-gdpr/") > -1) {
                return;
            }

            getAnnouncingFromCookie();
            checkForAvailableAnnouncing();

            UserActivity.init({
                secondsBeforeIdle: TIMEOUT_SECONDS_BETWEEN_REPETITIONS,
                onUserLeft: () => {
                    //console.log('onUserLeft');
                    if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef)
                },
                onUserReturnBack: () => {
                    //console.log('onUserReturnBack');
                    checkForAvailableAnnouncing()
                }
            });
        };

        function getAnnouncingFromCookie() {
            var temp = Cookies.get(GDPR_ANONYMOUS_ANNOUNCING);
            cookieAnnouncings = temp ? temp.split(ANONYMOUS_SEPERATOR) : [];
        }

        function checkForAvailableAnnouncing() {
            Rest.getAnnouncingForUser(
                function (announcing) { // success
                    //log.debug("Rest.getAnnouncingForUser data = " + JSON.stringify(announcing));
                    if (announcing) {
                        Rest.getAnnouncingBody(announcing.id, function (data) {
                            announcing.announcingbody = data;
                            /*if (announcementTimeoutRef) {
                                clearTimeout(announcementTimeoutRef);
                            }*/
                            if (announcing.style === "center") {
                                renderAnnouncingDialog(announcing);
                            } else if (announcing.style === "bottom") {
                                renderAnnouncingBottom(announcing);
                            }
                        })
                    } else {
                        if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef);
                        announcementTimeoutRef = setTimeout(checkForAvailableAnnouncing, TIMEOUT_SECONDS_BETWEEN_REPETITIONS * 1000);
                    }
                },
                function (error) { // error
                    log.error("Rest.getAnnouncingForUser error = " + JSON.stringify(error));
                });
        }

        function renderAnnouncingBottom(announcing) {
            var winNumericSize = Utils.getWinNumericaSize(announcing.windowSize);
            var bottom = ACTONIC.GDPR.GLOBAL.getAnnouncingBottom({
                id: announcing.id,
                title: announcing.title,
                baseUrl: AJS.contextPath(),
                body: announcing.body,
                type: announcing.type,
                method: "render",
                pageId: announcing.pageId,
                content: announcing.content,
                windowSize: winNumericSize,
                accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                action: "regular",
                announcingbody: announcing.announcingbody,
                questionnaire: announcing.questionnaire,
                response: ""
            });

            $("body").append(bottom);
            $("#announcing-bottom-" + announcing.id).show();
            $("#announcing-bottom-" + announcing.id + "-accept-btn").click(function () {
                //log.debug("accept-btn click");
                var request = Utils.getQuestionnaire();
                if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                    flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                    return;
                }
                Rest.acceptAnnouncing(announcing.id, request,
                    function () { // success
                        //log.debug("Rest.getAnnouncingForUser success");
                        // $("#announcing-bottom-" + announcing.id).hide();
                        $("#custom-main").remove();
                        $(".aui-blanket").hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.info.title"), AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.info.desc"), "info");
                        if (!announcing.extraFields.isLoggedIn) {
                            setAnnouncingCookie(announcing);
                        }
                        if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef);
                        announcementTimeoutRef = setTimeout(checkForAvailableAnnouncing, 2000);
                    },
                    function (error) { // error
                        log.error("Rest.acceptAnnouncing error = " + JSON.stringify(error));
                        // $("#announcing-bottom-" + announcing.id).hide();
                        $("#custom-main").remove();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.warning.title"), JSON.stringify(error), "warning");
                    });
            });
            $("#announcing-bottom-" + announcing.id + "-decline-btn").click(function () {
                //log.debug("cancel-btn click");
                var request = Utils.getQuestionnaire();
                if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                    flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                    return;
                }
                Rest.declineAnnouncing(announcing.id, request,
                    function () { // success
                        //log.debug("Rest.declineAnnouncing success");
                        // $("#announcing-bottom-" + announcing.id).hide();
                        $("#custom-main").remove();
                        $(".aui-blanket").hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.info.title"), AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.info.desc"), "info");
                        if (!announcing.extraFields.isLoggedIn) {
                            setAnnouncingCookie(announcing);
                        }
                        if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef);
                        announcementTimeoutRef = setTimeout(checkForAvailableAnnouncing, 2000);
                    },
                    function (error) { // error
                        log.error("Rest.declineAnnouncing error = " + JSON.stringify(error));
                        // $("#announcing-bottom-" + announcing.id).hide();
                        $("#custom-main").remove();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.warning.title"), JSON.stringify(error), "warning");
                    });
            });
        }

        function renderAnnouncingDialog(announcing) {
            var windowSize = announcing.windowSize ? announcing.windowSize : "medium";
            var dialog = ACTONIC.GDPR.GLOBAL.getAnnouncingDialog({
                id: announcing.id,
                title: announcing.title,
                baseUrl: AJS.contextPath(),
                body: announcing.body,
                type: announcing.type,
                pageId: announcing.pageId,
                content: announcing.content,
                windowSize: windowSize,
                accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                action: "regular",
                announcingbody: announcing.announcingbody,
                questionnaire: announcing.questionnaire,
                response: ""
            });

            $("body").append(dialog);
            AJS.dialog2("#announcing-dialog-" + announcing.id).show();
            $("#announcing-dialog-" + announcing.id + "-accept-btn").click(function () {
                //log.debug("accept-btn click");
                var request = Utils.getQuestionnaire();
                if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                    flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                    return;
                }
                Rest.acceptAnnouncing(announcing.id, request,
                    function () { // success
                        //log.debug("Rest.getAnnouncingForUser success");
                        AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.info.title"), AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.info.desc"), "info");
                        if (!announcing.extraFields.isLoggedIn) {
                            setAnnouncingCookie(announcing);
                        }
                        if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef);
                        announcementTimeoutRef = setTimeout(checkForAvailableAnnouncing, 2000);
                    },
                    function (error) { // error
                        log.error("Rest.acceptAnnouncing error = " + JSON.stringify(error));
                        AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.accept.flags.warning.title"), JSON.stringify(error), "warning");
                    });
            });
            $("#announcing-dialog-" + announcing.id + "-decline-btn").click(function () {
                //log.debug("cancel-btn click");
                var request = Utils.getQuestionnaire();
                if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                    flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                    return;
                }
                Rest.declineAnnouncing(announcing.id, request,
                    function () { // success
                        //log.debug("Rest.declineAnnouncing success");
                        AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.info.title"), AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.info.desc"), "info");
                        if (!announcing.extraFields.isLoggedIn) {
                            setAnnouncingCookie(announcing);
                        }
                        if (announcementTimeoutRef) clearTimeout(announcementTimeoutRef);
                        announcementTimeoutRef = setTimeout(checkForAvailableAnnouncing, 2000);
                    },
                    function (error) { // error
                        log.error("Rest.declineAnnouncing error = " + JSON.stringify(error));
                        AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                        flags.showFlag(AJS.I18n.getText("js-global.display-announcing.rest.decline.flags.warning.title"), JSON.stringify(error), "warning");
                    });
            });
        }

        function setAnnouncingCookie(announcing) {
            if (!cookieAnnouncings.includes(announcing.id.toString())) {
                cookieAnnouncings.push(announcing.id);
                Cookies.setForYears(GDPR_ANONYMOUS_ANNOUNCING, cookieAnnouncings.join(ANONYMOUS_SEPERATOR));
                getAnnouncingFromCookie();
            }
        }
    }

    return new Announcements();
});
