define("actonic-gdpr/data-level-agreement/rest", ["jquery"], function ($) {

    function Rest() {
        this.createRule = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement",
                data: request,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.updateRule = function (id, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id,
                data: request,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.toggleRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id + "/toggle",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.cloneRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id + "/clone",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.deleteRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "DELETE",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getIssueSecuritySchemes = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/issuesecurityschemes",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getIssueSecurityScheme = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/issuesecurityschemes/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getDataRulesConfigurationStatus = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/status",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.runRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/" + id + "/run",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAllRules = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.checkCron = function (cron, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/cron" ,
                data: {cron: cron},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.checkCql = function (cql, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/cql" ,
                data: {cql: cql},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getFilteredDataRuleHistory = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/filter" ,
                data: request,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }

    return new Rest();
});