/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleaner3dPartyAddonModel;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleaner3dPartyAddonEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleaner3dPartyAddonsDao;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleaner3dPartyAddonsManager {
    private static final Logger log = LoggerFactory.getLogger(DataCleaner3dPartyAddonsManager.class);
    private final DataCleaner3dPartyAddonsDao dataCleaner3dPartyAddonsDao;

    @Autowired
    public DataCleaner3dPartyAddonsManager(DataCleaner3dPartyAddonsDao dataCleaner3dPartyAddonsDao) {
        this.dataCleaner3dPartyAddonsDao = dataCleaner3dPartyAddonsDao;
    }

    private List<DataCleaner3dPartyAddonModel> entitiesToModels(DataCleaner3dPartyAddonEntity[] entities) {
        if (entities != null) {
            return Arrays.stream(entities).map(DataCleaner3dPartyAddonModel::fromEntity).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public DataCleaner3dPartyAddonModel create(Integer taskId, String eventId, String eventyType, String status, String anonymizerName, String statusMessage) {
        DataCleaner3dPartyAddonEntity entity = this.dataCleaner3dPartyAddonsDao.create(taskId, eventId, eventyType, status, anonymizerName, statusMessage);
        return DataCleaner3dPartyAddonModel.fromEntity(entity);
    }

    public DataCleaner3dPartyAddonModel update(String eventId, String status, String statusMessage) {
        DataCleaner3dPartyAddonEntity entity = this.dataCleaner3dPartyAddonsDao.getByEventId(eventId);
        if (entity != null) {
            entity = this.dataCleaner3dPartyAddonsDao.update(entity.getID(), status, statusMessage);
            return DataCleaner3dPartyAddonModel.fromEntity(entity);
        }
        log.warn(String.format("Entity for eventId = '%s' not found, update is not possible", eventId));
        return null;
    }

    public List<DataCleaner3dPartyAddonModel> getForTask(Integer taskId) {
        DataCleaner3dPartyAddonEntity[] entities = this.dataCleaner3dPartyAddonsDao.getByTaskId(taskId);
        return this.entitiesToModels(entities);
    }

    public DataCleaner3dPartyAddonModel getForEventId(String eventId) {
        DataCleaner3dPartyAddonEntity entity = this.dataCleaner3dPartyAddonsDao.getByEventId(eventId);
        return DataCleaner3dPartyAddonModel.fromEntity(entity);
    }

    public List<DataCleaner3dPartyAddonModel> getStillActiveAddonsAfter1H() {
        Date currentDate = new Date(new Date().getTime() - 3600000L);
        List<DataCleaner3dPartyAddonModel> models = this.entitiesToModels(this.dataCleaner3dPartyAddonsDao.getStillActiveAddonsAfter1H(currentDate));
        return models;
    }

    public void deleteByEventId(String eventId) {
        if (this.dataCleaner3dPartyAddonsDao.getByEventId(eventId) == null) {
            throw new NotFoundException(String.format("Entity for eventId = '%s' not found, deleting is not possible", eventId));
        }
        this.dataCleaner3dPartyAddonsDao.deleteByEventId(eventId);
    }

    public void deleteAllForTask(Integer taskId) {
        this.dataCleaner3dPartyAddonsDao.deleteByTaskId(taskId);
    }
}

