/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.opensymphony.module.propertyset.PropertySet;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.component.manager.AnnouncingDao;
import de.actonic.confluence.gdpr.component.manager.AnnouncingHistoryDao;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.model.ConfigOwnProfile;
import de.actonic.confluence.gdpr.model.ProfileVisibilityRuleModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProfileVisibilityService {
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private PluginSettings pluginSettings;
    private PluginSettings myProfileVisibility;
    private AnnouncingDao announcingDao;
    private final AnnouncingHistoryDao announcingHistoryDao;
    public final String ENABLE_FOR_ALL = "enabledForAll";
    public final String DISABLE_FOR_ALL = "disabledForAll";
    public final String ALLOW_CONFIG_OWN_PROFILE = "allowConfigOwnProfile";
    private final String CUSTOM = "custom";
    private final String PROPERTY_CUSTOM_PROFILE = "gdpr-custom-profile-visibility";

    @Autowired
    public ProfileVisibilityService(PluginSettingsFactory pluginSettingsFactory, GroupManager groupManager, UserAccessor userAccessor, AnnouncingDao announcingDao, AnnouncingHistoryDao announcingHistoryDao) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.confluence.confluence.gdpr.service.ProfileVisibility");
        this.myProfileVisibility = pluginSettingsFactory.createSettingsForKey("de.confluence.confluence.gdpr.service.ProfileVisibility.my.profile");
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.announcingDao = announcingDao;
        this.announcingHistoryDao = announcingHistoryDao;
    }

    public String getState() {
        String state = (String)this.pluginSettings.get("state");
        return Strings.isNullOrEmpty((String)state) ? "enabledForAll" : state;
    }

    public void setState(String state) {
        if (Strings.isNullOrEmpty((String)state) || !"allowConfigOwnProfile".equals(state) && !"enabledForAll".equals(state) && !"disabledForAll".equals(state) && !"custom".equals(state)) {
            this.pluginSettings.put("state", (Object)"enabledForAll");
        } else {
            this.pluginSettings.put("state", (Object)state);
        }
    }

    public void setUserProfileVisibilitySettings(ConfluenceUser confluenceUser, boolean hideFromEveryone) {
        PropertySet propertySet = this.userAccessor.getPropertySet(confluenceUser);
        propertySet.setBoolean("gdpr-custom-profile-visibility", hideFromEveryone);
    }

    public void removeUserHideFrom(String userName) {
        this.myProfileVisibility.remove(userName);
    }

    public String getUserHideFrom(String userName) {
        return (String)this.myProfileVisibility.get(userName);
    }

    public ConfigOwnProfile getPersonalProfileVisibilitySettings(ConfluenceUser confluenceUser) {
        ConfigOwnProfile configOwnProfile = new ConfigOwnProfile();
        String state = this.getState();
        if ("allowConfigOwnProfile".equalsIgnoreCase(state)) {
            configOwnProfile.setAllowConfigOwnProfile(true);
        }
        PropertySet propertySet = this.userAccessor.getPropertySet(confluenceUser);
        boolean isHideFromEveryone = propertySet.getBoolean("gdpr-custom-profile-visibility");
        configOwnProfile.setHideFromEveryone(isHideFromEveryone);
        return configOwnProfile;
    }

    public List<String> getTargetGroupNames(List<ProfileVisibilityRuleModel> profileVisibilityRuleModels) {
        ArrayList targetGroupNames = Lists.newArrayList();
        profileVisibilityRuleModels.forEach(profileVisibilityRuleModel -> targetGroupNames.add(profileVisibilityRuleModel.getTargetGroup()));
        return targetGroupNames;
    }

    public List<ProfileVisibilityRuleModel> getItems() {
        String rules = (String)this.pluginSettings.get("rules");
        if (Strings.isNullOrEmpty((String)rules)) {
            return Lists.newArrayList();
        }
        Gson gson = new Gson();
        List profileVisibilityRuleModels = (List)gson.fromJson(rules, new TypeToken<List<ProfileVisibilityRuleModel>>(){}.getType());
        return profileVisibilityRuleModels;
    }

    public List<ProfileVisibilityRuleModel> addItem(String targetGroup, String visibleGroups) {
        String rules = (String)this.pluginSettings.get("rules");
        List profileVisibilityRuleModels = Lists.newArrayList();
        Gson gson = new Gson();
        if (!Strings.isNullOrEmpty((String)rules)) {
            profileVisibilityRuleModels = (List)gson.fromJson(rules, new TypeToken<List<ProfileVisibilityRuleModel>>(){}.getType());
        }
        ArrayList visibleGroupsList = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)visibleGroups));
        profileVisibilityRuleModels.add(new ProfileVisibilityRuleModel(targetGroup, visibleGroupsList));
        this.pluginSettings.put("rules", (Object)gson.toJson((Object)profileVisibilityRuleModels));
        return profileVisibilityRuleModels;
    }

    public List<ProfileVisibilityRuleModel> deleteItem(String targetGroup) {
        String rules = (String)this.pluginSettings.get("rules");
        List profileVisibilityRuleModels = Lists.newArrayList();
        Gson gson = new Gson();
        if (!Strings.isNullOrEmpty((String)rules)) {
            profileVisibilityRuleModels = (List)gson.fromJson(rules, new TypeToken<List<ProfileVisibilityRuleModel>>(){}.getType());
        }
        Iterator profileVisibilityRuleModelIterator = profileVisibilityRuleModels.iterator();
        while (profileVisibilityRuleModelIterator.hasNext()) {
            ProfileVisibilityRuleModel profileVisibilityRuleModel = (ProfileVisibilityRuleModel)profileVisibilityRuleModelIterator.next();
            if (!Objects.equals(profileVisibilityRuleModel.getTargetGroup(), targetGroup)) continue;
            profileVisibilityRuleModelIterator.remove();
        }
        this.pluginSettings.put("rules", (Object)gson.toJson((Object)profileVisibilityRuleModels));
        return profileVisibilityRuleModels;
    }

    public boolean canUserSeeProfile(ConfluenceUser targetUser, String profileUserName) {
        if (Strings.isNullOrEmpty((String)profileUserName)) {
            return true;
        }
        ConfluenceUser profileUser = this.userAccessor.getUserByName(profileUserName);
        if (profileUser == null) {
            return false;
        }
        if (profileUser == targetUser) {
            return true;
        }
        String state = this.getState();
        if (StringUtils.equalsIgnoreCase((String)state, (String)"allowConfigOwnProfile")) {
            return !this.getPersonalProfileVisibilitySettings(profileUser).isHideFromEveryone();
        }
        if (StringUtils.equalsIgnoreCase((String)state, (String)"enabledForAll")) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((String)state, (String)"disabledForAll")) {
            return false;
        }
        if (targetUser == null) {
            return false;
        }
        AtomicBoolean canUserSeeProfile = new AtomicBoolean(false);
        List<ProfileVisibilityRuleModel> rules = this.getItems();
        rules.forEach(profileVisibilityRuleModel -> this.getGroupsForUser(targetUser).forEach(targetGroup -> {
            if (targetGroup.getName().equals(profileVisibilityRuleModel.getTargetGroup())) {
                profileVisibilityRuleModel.getVisibleGroups().forEach(groupName -> this.getGroupsForUser(profileUser).forEach(visibleGroup -> {
                    if (visibleGroup.getName().equals(groupName)) {
                        canUserSeeProfile.set(true);
                    }
                }));
            }
        }));
        return canUserSeeProfile.get();
    }

    public List<AnnouncingModel> getAnnouncementByUser(ConfluenceUser applicationUser) {
        ArrayList announcingModels = Lists.newArrayList();
        List<AnnouncingEntity> activeAnnouncing = this.announcingDao.getActiveEntities();
        List<Group> groups = this.getGroupsForUser(applicationUser);
        boolean isRelevant = false;
        for (AnnouncingEntity announcingEntity : activeAnnouncing) {
            for (Group group : groups) {
                if (!group.getName().equals(announcingEntity.getGroup())) continue;
                isRelevant = true;
            }
            if (StringUtils.isEmpty((String)announcingEntity.getGroup())) {
                isRelevant = true;
            }
            if (!isRelevant) continue;
            isRelevant = false;
            applicationUser.getName();
            String status = this.announcingHistoryDao.getAnswerByIdAndUser(announcingEntity.getID(), applicationUser.getKey().toString());
            String response = this.announcingHistoryDao.getQueResponse(announcingEntity.getID(), applicationUser.getKey().toString());
            ImmutableMap extraFields = ImmutableMap.of((Object)"status", (Object)status, (Object)"response", (Object)(Strings.isNullOrEmpty((String)response) ? "" : response));
            announcingModels.add(new AnnouncingModel(announcingEntity, (Map)extraFields));
        }
        return announcingModels;
    }

    public boolean updateAnswer(int id, String answer, String user, String questionnaire, String ip) {
        AnnouncingEntity announcingEntity = this.announcingDao.getById(id);
        return this.announcingHistoryDao.updateEntity(id, answer, user, announcingEntity, questionnaire, ip);
    }

    private List<Group> getGroupsForUser(ConfluenceUser confluenceUser) {
        ArrayList groups = Lists.newArrayList();
        Pager pager = null;
        try {
            pager = this.groupManager.getGroups((User)confluenceUser);
        }
        catch (EntityException e) {
            e.printStackTrace();
            return groups;
        }
        while (!pager.onLastPage()) {
            groups.addAll(pager.getCurrentPage());
        }
        if (pager.onLastPage()) {
            groups.addAll(pager.getCurrentPage());
        }
        return groups;
    }
}

