/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CronManager {
    public final Logger log = LoggerFactory.getLogger(CronManager.class);
    private static final Long TIME_BETWEEN_EXECUTIONS = 3500L;

    public boolean isCronValid(String cronExpression) {
        try {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(cronDefinition);
            Cron quartzCron = parser.parse(cronExpression);
            quartzCron.validate();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ZonedDateTime getLastExecution(String cronExpression) {
        ZonedDateTime now = ZonedDateTime.now();
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
        ZonedDateTime lastExecution = (ZonedDateTime)executionTime.lastExecution(now).get();
        this.log.debug("lastExecution = " + lastExecution);
        ZonedDateTime nextExecution = (ZonedDateTime)executionTime.nextExecution(now).get();
        this.log.debug("nextExecution = " + nextExecution);
        Duration timeFromLastExecution = (Duration)executionTime.timeFromLastExecution(now).get();
        this.log.debug("timeFromLastExecution = " + timeFromLastExecution);
        Duration timeToNextExecution = (Duration)executionTime.timeToNextExecution(now).get();
        this.log.debug("timeToNextExecution = " + timeToNextExecution);
        CronDescriptor descriptor = CronDescriptor.instance((Locale)Locale.UK);
        String description = descriptor.describe(parser.parse(cronExpression));
        this.log.debug("description = " + description);
        long totalDuration = timeFromLastExecution.toMillis() + timeToNextExecution.toMillis();
        this.log.debug("totalDuration = " + totalDuration);
        return lastExecution;
    }

    public long getLastExecutionInMillis(String cronExpression) {
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
        if (executionTime.lastExecution(ZonedDateTime.now()).isPresent()) {
            ZonedDateTime lastExecution = (ZonedDateTime)executionTime.lastExecution(ZonedDateTime.now()).get();
            return lastExecution.toInstant().toEpochMilli();
        }
        return -1L;
    }

    public long getSecondsBetweenExecution(String cronExpression) {
        ZonedDateTime now;
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
        if (!executionTime.timeToNextExecution(now = ZonedDateTime.now()).isPresent()) {
            return -1L;
        }
        Duration execution = (Duration)executionTime.timeToNextExecution(now).get();
        ZonedDateTime future = now.plusSeconds(execution.getSeconds() + 3L);
        Duration previousExecution = (Duration)executionTime.timeFromLastExecution(future).get();
        Duration nextExecution = executionTime.timeToNextExecution(future).isPresent() ? (Duration)executionTime.timeToNextExecution(future).get() : Duration.ofSeconds(3600L);
        return nextExecution.getSeconds() + previousExecution.getSeconds();
    }

    public boolean isCronDurationValid(String cronExpression) {
        long secondsBetweenExecution = this.getSecondsBetweenExecution(cronExpression);
        return secondsBetweenExecution > TIME_BETWEEN_EXECUTIONS;
    }

    public ZonedDateTime getNextExecution(String cronExpression) {
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
        ZonedDateTime now = ZonedDateTime.now();
        return (ZonedDateTime)executionTime.nextExecution(now).get();
    }

    public String getHumanReadableFormat(String cron) {
        try {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(cronDefinition);
            CronDescriptor descriptor = CronDescriptor.instance((Locale)Locale.UK);
            String description = descriptor.describe(parser.parse(cron));
            return description;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "can not parse cron";
        }
    }

    public boolean isExecutionTimeComes(Long lastExecutionByCron, Long lastExecutionByTask) {
        return lastExecutionByCron > lastExecutionByTask;
    }
}

