/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.CopyOnWriteLinkedHashMap;

public class TypeResolvingList<T>
extends AbstractList<T> {
    private final Map<T, Class<?>> elements = new CopyOnWriteLinkedHashMap();
    private final Class<? super T> valueAccessorType;

    public TypeResolvingList(Class<? super T> valueAccessorType) {
        this.valueAccessorType = valueAccessorType;
    }

    @Override
    public void add(int index, T element) {
        this.addElement(element);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean add(T element) {
        return this.addElement(element);
    }

    @Override
    public T get(int index) {
        Iterator<T> iterator = this.elements.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T e : c) {
            changed = this.addElement(e) || changed;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public T remove(int index) {
        T element = this.get(index);
        this.elements.remove(element);
        return element;
    }

    @Override
    public boolean remove(Object o) {
        this.elements.remove(o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            Object e;
            Object t2 = e = iterator.next();
            this.elements.remove(t2);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private boolean addElement(T element) {
        Assert.notNull(element, "element");
        Class<?> typeArgument = TypeResolver.resolveRawArgument(this.valueAccessorType, element.getClass());
        if (typeArgument == null) {
            throw new IllegalArgumentException("Must declare source type argument <T> for the " + this.valueAccessorType.getSimpleName());
        }
        this.elements.put(element, typeArgument);
        return true;
    }

    public T first(Class<?> type) {
        for (Map.Entry<T, Class<?>> entry : this.elements.entrySet()) {
            if (!entry.getValue().isAssignableFrom(type)) continue;
            return entry.getKey();
        }
        return null;
    }
}

