/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.Condition;
import org.modelmapper.ConfigurationException;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.TypeMap;
import org.modelmapper.TypeToken;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingContextImpl;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoRegistry;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.ProvisionRequestImpl;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.TypeMapStore;
import org.modelmapper.internal.TypePair;
import org.modelmapper.internal.converter.ConverterStore;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Objects;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConstantMapping;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.MappingEngine;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

public class MappingEngineImpl
implements MappingEngine {
    private final Map<TypePair<?, ?>, Converter<?, ?>> converterCache = new ConcurrentHashMap();
    private final InheritingConfiguration configuration;
    private final TypeMapStore typeMapStore;
    private final ConverterStore converterStore;

    public MappingEngineImpl(InheritingConfiguration configuration) {
        this.configuration = configuration;
        this.typeMapStore = configuration.typeMapStore;
        this.converterStore = configuration.converterStore;
    }

    public <S, D> D map(S source, Class<S> sourceType, D destination, TypeToken<D> destinationTypeToken, String typeMapName) {
        MappingContextImpl<S, D> context = new MappingContextImpl<S, D>(source, sourceType, destination, destinationTypeToken.getRawType(), destinationTypeToken.getType(), typeMapName, this);
        D result = null;
        try {
            result = this.map(context);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (ErrorsException e) {
            throw context.errors.toMappingException();
        }
        catch (Throwable t2) {
            context.errors.errorMapping(sourceType, destinationTypeToken.getType(), t2);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
        return result;
    }

    @Override
    public <S, D> D map(MappingContext<S, D> context) {
        Object circularDest;
        MappingContextImpl contextImpl = (MappingContextImpl)context;
        Class<D> destinationType = context.getDestinationType();
        if (!Iterables.isIterable(destinationType) && (circularDest = contextImpl.destinationForSource()) != null && circularDest.getClass().isAssignableFrom(contextImpl.getDestinationType())) {
            return circularDest;
        }
        D destination = null;
        TypeMap<S, D> typeMap = this.typeMapStore.get(context.getSourceType(), context.getDestinationType(), context.getTypeMapName());
        if (typeMap != null) {
            destination = this.typeMap(contextImpl, typeMap);
        } else {
            Converter<S, D> converter = this.converterFor(context);
            if (converter != null && (context.getDestination() == null || context.getParent() != null)) {
                destination = this.convert(context, converter);
            } else if (!Primitives.isPrimitive(context.getSourceType()) && !Primitives.isPrimitive(context.getDestinationType())) {
                typeMap = this.typeMapStore.getOrCreate(context.getSource(), context.getSourceType(), context.getDestinationType(), context.getTypeMapName(), this);
                destination = this.typeMap(contextImpl, typeMap);
            } else if (context.getDestinationType().isAssignableFrom(context.getSourceType())) {
                destination = (D)context.getSource();
            }
        }
        contextImpl.setDestination(destination, true);
        return destination;
    }

    <S, D> D typeMap(MappingContextImpl<S, D> context, TypeMap<S, D> typeMap) {
        D destination;
        boolean noSkip;
        if (context.getParent() != null && context.getDestination() == null) {
            context.setDestination(this.destinationProperty(context), false);
        }
        context.setTypeMap(typeMap);
        Condition<?, ?> condition = typeMap.getCondition();
        boolean bl = noSkip = condition == null || condition.applies(context);
        if (noSkip && typeMap.getConverter() != null) {
            return this.convert(context, typeMap.getConverter());
        }
        if (context.getDestination() == null && Types.isInstantiable(context.getDestinationType()) && (destination = this.createDestination(context)) == null) {
            return null;
        }
        if (noSkip) {
            Converter<S, D> converter = typeMap.getPreConverter();
            if (converter != null) {
                context.setDestination(this.convert(context, converter), true);
            }
            for (Mapping mapping : typeMap.getMappings()) {
                this.propertyMap(mapping, context);
            }
            converter = typeMap.getPostConverter();
            if (converter != null) {
                context.setDestination(this.convert(context, converter), true);
            }
        }
        return context.getDestination();
    }

    private <S, D> void propertyMap(Mapping mapping, MappingContextImpl<S, D> context) {
        MappingImpl mappingImpl = (MappingImpl)mapping;
        String propertyPath = context.destinationPath + mappingImpl.getPath();
        if (context.isShaded(propertyPath)) {
            return;
        }
        if (mapping.getCondition() == null && mapping.isSkipped()) {
            return;
        }
        Object source = this.resolveSourceValue(context, mapping);
        MappingContextImpl<Object, Object> propertyContext = this.propertyContextFor(context, source, mappingImpl);
        Condition condition = Objects.firstNonNull(mapping.getCondition(), context.getTypeMap().getPropertyCondition(), this.configuration.getPropertyCondition());
        if (condition != null) {
            boolean conditionIsTrue = condition.applies(propertyContext);
            if (conditionIsTrue && mapping.isSkipped()) {
                return;
            }
            if (!conditionIsTrue && !mapping.isSkipped()) {
                context.shadePath(propertyPath);
                return;
            }
        }
        this.setDestinationValue(context, propertyContext, mappingImpl);
    }

    private Object resolveSourceValue(MappingContextImpl<?, ?> context, Mapping mapping) {
        Object source = context.getSource();
        if (mapping instanceof PropertyMappingImpl) {
            StringBuilder destPathBuilder = new StringBuilder().append(context.destinationPath);
            for (Accessor accessor : ((PropertyMapping)mapping).getSourceProperties()) {
                Object circularDest;
                destPathBuilder.append(accessor.getName()).append('.');
                source = accessor.getValue(source);
                context.addParentSource(destPathBuilder.toString(), source);
                if (source == null) {
                    return null;
                }
                if (Iterables.isIterable(source.getClass()) || (circularDest = context.sourceToDestination.get(source)) == null) continue;
                context.intermediateDestinations.put(destPathBuilder.toString(), circularDest);
            }
        } else if (mapping instanceof ConstantMapping) {
            source = ((ConstantMapping)mapping).getConstant();
            context.addParentSource("", source);
        }
        return source;
    }

    private <S, D> void setDestinationValue(MappingContextImpl<S, D> context, MappingContextImpl<Object, Object> propertyContext, MappingImpl mapping) {
        Object destination;
        String destPath = context.destinationPath + mapping.getPath();
        Converter<Object, Object> converter = Objects.firstNonNull(mapping.getConverter(), context.getTypeMap().getPropertyConverter());
        if (converter != null) {
            context.shadePath(destPath);
        }
        if ((destination = propertyContext.getParentDestination()) == null) {
            return;
        }
        Mutator mutator = (Mutator)mapping.getLastDestinationProperty();
        Accessor accessor = PropertyInfoRegistry.accessorFor(mutator.getInitialType(), mutator.getName(), this.configuration);
        Object destinationValue = propertyContext.createDestinationViaProvider();
        if (destinationValue == null && propertyContext.isProvidedDestination() && accessor != null) {
            destinationValue = accessor.getValue(destination);
            propertyContext.setDestination(destinationValue, false);
        }
        if (converter != null) {
            destinationValue = this.convert(propertyContext, converter);
        } else if (propertyContext.getSource() != null) {
            destinationValue = this.map(propertyContext);
        } else {
            converter = this.converterFor(propertyContext);
            if (converter != null) {
                destinationValue = this.convert(propertyContext, converter);
            }
        }
        context.destinationCache.put(destPath, destinationValue);
        if (destinationValue != null || !this.configuration.isSkipNullEnabled()) {
            mutator.setValue(destination, destinationValue == null ? Primitives.defaultValue(mutator.getType()) : destinationValue);
        }
        if (destinationValue == null) {
            context.shadePath(propertyContext.destinationPath);
        }
    }

    private MappingContextImpl<Object, Object> propertyContextFor(MappingContextImpl<?, ?> context, Object source, MappingImpl mapping) {
        Class<Object> sourceType = mapping.getSourceType();
        if (source != null) {
            sourceType = Types.deProxy(source.getClass());
        }
        boolean cyclic = mapping instanceof PropertyMapping && ((PropertyMappingImpl)mapping).cyclic;
        Class<?> destinationType = mapping.getLastDestinationProperty().getType();
        Type genericDestinationType = context.genericDestinationPropertyType(mapping.getLastDestinationProperty().getGenericType());
        return new MappingContextImpl<Object, Object>(context, source, sourceType, null, destinationType, genericDestinationType, mapping, !cyclic);
    }

    private <S, D> D destinationProperty(MappingContextImpl<S, D> context) {
        if (!context.isProvidedDestination() || context.getMapping() == null) {
            return null;
        }
        Object intermediateDest = context.getParent().getDestination();
        List<? extends PropertyInfo> mutatorChain = context.getMapping().getDestinationProperties();
        for (Mutator mutator : mutatorChain) {
            if (intermediateDest == null) break;
            Accessor accessor = TypeInfoRegistry.typeInfoFor(intermediateDest.getClass(), this.configuration).getAccessors().get(mutator.getName());
            if (accessor == null) continue;
            intermediateDest = accessor.getValue(intermediateDest);
        }
        Object destinationProperty = intermediateDest;
        return (D)destinationProperty;
    }

    private <S, D> D convert(MappingContext<S, D> context, Converter<S, D> converter) {
        try {
            return converter.convert(context);
        }
        catch (ErrorsException e) {
            throw e;
        }
        catch (Exception e) {
            ((MappingContextImpl)context).errors.errorConverting(converter, context.getSourceType(), context.getDestinationType(), e);
            return null;
        }
    }

    private <S, D> Converter<S, D> converterFor(MappingContext<S, D> context) {
        TypePair<S, D> typePair = TypePair.of(context.getSourceType(), context.getDestinationType(), context.getTypeMapName());
        Converter<?, ?> converter = this.converterCache.get(typePair);
        if (converter == null && (converter = this.converterStore.getFirstSupported(context.getSourceType(), context.getDestinationType())) != null) {
            this.converterCache.put(typePair, converter);
        }
        return converter;
    }

    private <T> T instantiate(Class<T> type, Errors errors) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            errors.errorInstantiatingDestination(type, e);
            return null;
        }
    }

    @Override
    public <S, D> D createDestination(MappingContext<S, D> context) {
        MappingContextImpl contextImpl = (MappingContextImpl)context;
        Object destination = contextImpl.createDestinationViaProvider();
        if (destination == null) {
            destination = this.instantiate(context.getDestinationType(), contextImpl.errors);
        }
        contextImpl.setDestination(destination, true);
        return destination;
    }

    InheritingConfiguration getConfiguration() {
        return this.configuration;
    }

    <S, D> D createDestinationViaGlobalProvider(S source, Class<D> requestedType, Errors errors) {
        D destination = null;
        Provider<?> provider = this.configuration.getProvider();
        if (provider != null) {
            destination = (D)provider.get(new ProvisionRequestImpl<D>(source, requestedType));
            this.validateDestination(requestedType, destination, errors);
        }
        if (destination == null) {
            destination = this.instantiate(requestedType, errors);
        }
        return destination;
    }

    void validateDestination(Class<?> destinationType, Object destination, Errors errors) {
        if (destination != null && !destinationType.isAssignableFrom(destination.getClass())) {
            errors.invalidProvidedDestinationInstance(destination, destinationType);
        }
    }
}

