/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.enums.ImportExportFormat;
import cz.morosystems.namymap.common.expimp.SourceImporter;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.dto.AttachmentDto;
import cz.morosystems.namymap.server.servlet.ExportImportValidationServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UploadFileServlet
extends ExportImportValidationServlet {
    private static final Logger log = LoggerFactory.getLogger(UploadFileServlet.class);
    @Autowired
    private AttachmentService attachmentService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            resp.sendError(401, "User not logged in.");
            return;
        }
        if (!NamymapPermissionManager.canAttachMapToPage(pageId, (User)confluenceUser)) {
            resp.sendError(401, "User has no permission for attachments on model page.");
            return;
        }
        if (pageId == null) {
            resp.sendError(400, "Missing pageId parameter.");
            return;
        }
        String format = this.getParameter(req, "format");
        SourceImporter importer = this.getImporter(ImportExportFormat.fromCodeDefaultEasyMind(format));
        FileItem item = this.getMultipartParameter("model");
        AttachmentDto attachment = this.attachmentService.importFile(pageId, importer, item.getInputStream(), item.getName());
        this.writeAsJsonToSuccessfulResponse(resp, attachment);
    }
}

