/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import cz.morosystems.namymap.common.exception.NamymapException;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TemplateServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(TemplateServlet.class);
    @Autowired
    private MindMapTemplateService mindMapTemplateService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String templateAction = this.getParameter(req, "templateAction");
        String templateKey = this.getParameter(req, "templateKey");
        String templateName = this.getParameter(req, "templateName");
        if (StringUtils.isBlank(templateAction)) {
            resp.sendError(400, "Missing template action parameter.");
            return;
        }
        try {
            this.processTemplateAction(templateAction, templateKey, templateName, resp);
        }
        catch (NamymapException e) {
            resp.sendError(400, e.getMessage());
            log.error("Cannot process {} operation.", (Object)templateAction, (Object)e);
        }
    }

    private void processTemplateAction(String templateAction, String templateKey, String templateName, HttpServletResponse resp) throws IOException {
        switch (StringUtils.lowerCase(templateAction)) {
            case "get_template": {
                Validate.notBlank(templateKey);
                NamymapTemplate template = this.mindMapTemplateService.getTemplate(templateKey);
                Validate.notNull(template, String.format("Template with key: %s has not been found", templateKey), new Object[0]);
                this.writeAsJsonToSuccessfulResponse(resp, template.getMap());
                break;
            }
            case "template_list": {
                List<NamymapTemplate> templateList = this.mindMapTemplateService.getAllTemplates();
                this.writeAsJsonToSuccessfulResponse(resp, templateList);
                break;
            }
            case "template_rename": {
                this.mindMapTemplateService.renameTemplate(templateKey, templateName);
                this.writeAsJsonToSuccessfulResponse(resp, templateKey);
                break;
            }
            case "template_remove": {
                this.mindMapTemplateService.deleteTemplate(templateKey);
                this.writeAsJsonToSuccessfulResponse(resp, templateKey);
                break;
            }
            case "template_exists": {
                List<NamymapTemplate> templates = this.mindMapTemplateService.getAllTemplates();
                boolean found = templates.stream().anyMatch(t2 -> StringUtils.equalsIgnoreCase(t2.getName(), templateName));
                this.writeAsJsonToSuccessfulResponse(resp, found);
                break;
            }
            default: {
                throw new NamymapException("Unsupported action parameter.");
            }
        }
    }
}

