/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import cz.morosystems.namymap.common.InfrastructureUtil;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import cz.morosystems.namymap.server.service.dto.TemplateDto;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveTemplateServlet
extends CommonWithDataServlet {
    @Autowired
    private MindMapTemplateService mindMapTemplateService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String templateName = this.getParameter(req, "templateName");
        String templateKey = this.getParameter(req, "templateKey");
        Boolean shared = Boolean.valueOf(this.getParameter(req, "templateShared"));
        String stringifiedMindmapJson = this.getParameter(req, "stringifiedMindmapJson");
        String stringifiedMindmapJsonWithFormatVersion = InfrastructureUtil.addMindmapFormatVersion(stringifiedMindmapJson);
        if (templateName == null) {
            resp.sendError(400, "Template name cannot be null.");
            return;
        }
        if (stringifiedMindmapJsonWithFormatVersion == null) {
            resp.sendError(400, "Data JSON cannot be null.");
            return;
        }
        TemplateDto template = this.mindMapTemplateService.createOrUpdateTemplate(templateKey, templateName, stringifiedMindmapJsonWithFormatVersion, shared);
        this.writeAsJsonToSuccessfulResponse(resp, template);
    }
}

