/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoveMindmapServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(RemoveMindmapServlet.class);
    @Autowired
    private AttachmentService attachmentService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String mindmapName = this.getParameter(req, "mindmapName");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Validate.notNull(pageId);
        Validate.notNull(mindmapName);
        try {
            this.checkReadPermissions(pageId, confluenceUser);
        }
        catch (NamymapSecurityException se) {
            log.error("Remove Mind Map failed, unauthorized: ", (Throwable)se);
            resp.sendError(401, se.getMessage());
            return;
        }
        Boolean removeMacro = this.getParameterBoolean(req, "remove");
        this.attachmentService.removeMindMap(pageId, mindmapName, BooleanUtils.isTrue(removeMacro));
        resp.setStatus(200);
    }
}

