/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.model.AttachmentLoadObject;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadMindmapServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(LoadMindmapServlet.class);
    @Autowired
    private AttachmentService attachmentService;

    @Override
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long pageId = this.getParameterLong(req, "pageId");
        String mindmapName = this.getParameter(req, "mindmapName");
        Integer version = this.getParameterInteger(req, "version");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        try {
            this.checkReadPermissions(pageId, confluenceUser);
        }
        catch (NamymapSecurityException se) {
            log.error("Load Mind Map failed, unauthorized: ", (Throwable)se);
            resp.sendError(401, se.getMessage());
            return;
        }
        if (pageId == null) {
            resp.sendError(400, "Page id is required.");
            return;
        }
        if (StringUtils.isBlank(mindmapName)) {
            resp.sendError(400, "mindmapName is required.");
            return;
        }
        AttachmentObject attachmentObject = this.attachmentService.loadMindmapAsAttachmentObject(pageId, mindmapName, version, confluenceUser);
        this.writeAsJsonToSuccessfulResponse(resp, AttachmentLoadObject.fromAttachmentObject(attachmentObject));
    }
}

