/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import cz.morosystems.namymap.common.enums.ImportExportFormat;
import cz.morosystems.namymap.common.expimp.SourceExporter;
import cz.morosystems.namymap.common.expimp.SourceImporter;
import cz.morosystems.namymap.common.expimp.SourceValidator;
import cz.morosystems.namymap.common.expimp.em.EasyMindExporterImporterValidator;
import cz.morosystems.namymap.common.expimp.freemind.FreeMindExporterImporterValidator;
import cz.morosystems.namymap.common.expimp.freeplane.FreePlaneExporterImporterValidator;
import cz.morosystems.namymap.common.expimp.xmind.XMindExporterImporterValidator;
import cz.morosystems.namymap.common.expimp.xmind.guts.json.XmindJsonExporter;
import cz.morosystems.namymap.common.expimp.xmind.guts.xml.XmindXmlExporter;
import cz.morosystems.namymap.server.export.EasyMindPNGExporter;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.servlet.CommonWithDataServlet;
import java.util.EnumMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ExportImportValidationServlet
extends CommonWithDataServlet {
    private static final Logger log = LoggerFactory.getLogger(ExportImportValidationServlet.class);
    @Autowired
    protected AttachmentService attachmentService;
    private final EnumMap<ImportExportFormat, SourceValidator> validators = new EnumMap(ImportExportFormat.class);
    private final EnumMap<ImportExportFormat, SourceImporter> importers = new EnumMap(ImportExportFormat.class);
    private final EnumMap<ImportExportFormat, SourceExporter> exporters = new EnumMap(ImportExportFormat.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        EasyMindExporterImporterValidator emiv = new EasyMindExporterImporterValidator();
        this.validators.put(ImportExportFormat.EASY_MIND, emiv);
        this.importers.put(ImportExportFormat.EASY_MIND, emiv);
        this.exporters.put(ImportExportFormat.EASY_MIND, emiv);
        FreeMindExporterImporterValidator fmiv = new FreeMindExporterImporterValidator();
        this.validators.put(ImportExportFormat.FREE_MIND, fmiv);
        this.importers.put(ImportExportFormat.FREE_MIND, fmiv);
        this.exporters.put(ImportExportFormat.FREE_MIND, fmiv);
        FreePlaneExporterImporterValidator fpiv = new FreePlaneExporterImporterValidator();
        this.validators.put(ImportExportFormat.FREE_PLANE, fpiv);
        this.importers.put(ImportExportFormat.FREE_PLANE, fpiv);
        this.exporters.put(ImportExportFormat.FREE_PLANE, fpiv);
        XMindExporterImporterValidator xmiv = new XMindExporterImporterValidator();
        this.validators.put(ImportExportFormat.X_MIND, xmiv);
        this.importers.put(ImportExportFormat.X_MIND, xmiv);
        this.exporters.put(ImportExportFormat.X_MIND, new XMindExporterImporterValidator(XmindXmlExporter.initXmindXmlExporter()));
        this.exporters.put(ImportExportFormat.XMIND_JSON, new XMindExporterImporterValidator(XmindJsonExporter.initXmindJsonExporter()));
        this.exporters.put(ImportExportFormat.IMG_PNG, new EasyMindPNGExporter(this.attachmentService));
    }

    SourceValidator getValidator(ImportExportFormat f) {
        if (f == null) {
            throw new IllegalArgumentException("Invalid validator null");
        }
        return this.validators.get((Object)f);
    }

    SourceImporter getImporter(ImportExportFormat f) {
        if (f == null) {
            throw new IllegalArgumentException("Invalid importer null");
        }
        return this.importers.get((Object)f);
    }

    SourceExporter getExporter(ImportExportFormat f) {
        if (f == null) {
            throw new IllegalArgumentException("Invalid exporter null");
        }
        return this.exporters.get((Object)f);
    }
}

