/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.servlet;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.Constants;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;

public abstract class CommonServlet
extends HttpServlet {
    void writeAsJsonToSuccessfulResponse(HttpServletResponse resp, Object responseObject) throws IOException {
        this.writeAsJsonToResponse(resp, responseObject, 200);
    }

    void writeAsByteArrayToSuccessfulResponse(HttpServletResponse resp, byte[] responseByteArray, String contentType) throws IOException {
        this.writeAsByteArrayToResponse(resp, responseByteArray, 200, contentType);
    }

    private void writeAsJsonToResponse(HttpServletResponse resp, Object responseObject, int responseCode) throws IOException {
        Validate.notNull(resp);
        Validate.notNull(responseObject);
        resp.setContentType("application/json");
        try (PrintWriter out = resp.getWriter();){
            out.write(Constants.OBJECT_MAPPER.writeValueAsString(responseObject));
        }
        resp.setStatus(responseCode);
    }

    private void writeAsByteArrayToResponse(HttpServletResponse resp, byte[] responseByteArray, int responseCode, String contentType) throws IOException {
        Validate.notNull(resp);
        Validate.notBlank(contentType);
        resp.setContentLength(responseByteArray.length);
        resp.setContentType(contentType);
        try (ServletOutputStream out = resp.getOutputStream();){
            out.write(responseByteArray);
        }
        resp.setStatus(responseCode);
    }

    protected void checkReadPermissions(long pageId, ConfluenceUser confluenceUser) {
        if (!NamymapPermissionManager.canReadMapModelFromPage(pageId, (User)confluenceUser)) {
            throw new NamymapSecurityException("User has no permission for reading map from model page.");
        }
    }
}

