/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.dto.UserPropertyDto;
import cz.morosystems.namymap.server.service.UserService;
import java.io.IOException;
import java.util.Date;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final transient LocaleManager localeManager;
    private final ObjectMapper objectMapper;
    private final PluginSettings pluginSettings;

    @Autowired
    public UserServiceImpl(@ComponentImport @NonNull LocaleManager localeManager, @ComponentImport @NonNull PluginSettingsFactory pluginSettingsFactory) {
        if (localeManager == null) {
            throw new NullPointerException("localeManager");
        }
        if (pluginSettingsFactory == null) {
            throw new NullPointerException("pluginSettingsFactory");
        }
        this.localeManager = localeManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String getUserLanguage() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.localeManager.getLocale((User)user).toString();
    }

    @Override
    public UserPropertyDto getUserProperty(String propertyKey) {
        try {
            Object result = this.pluginSettings.get(this.createUserPropertyKey(propertyKey));
            if (result instanceof String) {
                return this.objectMapper.readValue((String)result, UserPropertyDto.class);
            }
        }
        catch (IOException e) {
            log.error("Error reading user property: {}", (Object)propertyKey, (Object)e);
        }
        return null;
    }

    @Override
    public UserPropertyDto createUserProperty(String propertyKey, Object value) {
        UserPropertyDto userPropertyDto = new UserPropertyDto();
        userPropertyDto.setValue(value);
        userPropertyDto.setKey(propertyKey);
        userPropertyDto.setCreatedDate(new Date().toString());
        try {
            this.pluginSettings.put(this.createUserPropertyKey(propertyKey), (Object)this.objectMapper.writeValueAsString(userPropertyDto));
        }
        catch (JsonProcessingException e) {
            log.error("Error creating user property: {}", (Object)propertyKey, (Object)e);
        }
        return userPropertyDto;
    }

    private String createUserPropertyKey(String propertyKey) {
        return String.format("User_%s_Property_%s", AuthenticatedUserThreadLocal.get().getKey().getStringValue(), propertyKey);
    }
}

