/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import cz.morosystems.namymap.server.service.AttachmentService;
import cz.morosystems.namymap.server.service.ContentService;
import cz.morosystems.namymap.server.service.RenameService;
import cz.morosystems.namymap.server.service.dto.MindMapRenameResultDto;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RenameServiceImpl
implements RenameService {
    private static final Logger log = LoggerFactory.getLogger(RenameServiceImpl.class);
    private final AttachmentService attachmentService;
    private final ContentService contentService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public RenameServiceImpl(@NonNull AttachmentService attachmentService, @NonNull ContentService contentService, @ComponentImport @NonNull TransactionTemplate transactionTemplate) {
        if (attachmentService == null) {
            throw new NullPointerException("attachmentService");
        }
        if (contentService == null) {
            throw new NullPointerException("contentService");
        }
        if (transactionTemplate == null) {
            throw new NullPointerException("transactionTemplate");
        }
        this.attachmentService = attachmentService;
        this.contentService = contentService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public MindMapRenameResultDto renameMindMap(@NonNull Long pageId, @NonNull String mindmapName, @NonNull String newMindmapName) {
        if (pageId == null) {
            throw new NullPointerException("pageId");
        }
        if (mindmapName == null) {
            throw new NullPointerException("mindmapName");
        }
        if (newMindmapName == null) {
            throw new NullPointerException("newMindmapName");
        }
        return (MindMapRenameResultDto)this.transactionTemplate.execute(() -> {
            this.contentService.renameMacroInPage(pageId, mindmapName, newMindmapName, true);
            this.attachmentService.copyMindMapAttachments(pageId, mindmapName, newMindmapName);
            return MindMapRenameResultDto.builder().pageId(pageId).mindmapName(newMindmapName).legacyModelPageId(pageId).legacyModelFileName(newMindmapName).build();
        });
    }

    private boolean shouldRenameAttachment(Long pageId, String mindmapName, Long modelPageId, String modelFileName) {
        return !(modelPageId != null && !modelPageId.equals(pageId) || modelFileName != null && !modelFileName.equals(mindmapName));
    }
}

