/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.EasyMindVersionConverter;
import cz.morosystems.namymap.server.model.AttachmentLoadObject;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.model.ao.MindMapTemplateAo;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import cz.morosystems.namymap.server.service.dto.TemplateDto;
import cz.morosystems.namymap.server.utils.AoUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class MindMapTemplateServiceImpl
implements MindMapTemplateService {
    private static final Logger log = LoggerFactory.getLogger(MindMapTemplateServiceImpl.class);
    private static final String TEMPLATES_PATH = "mind-map-templates";
    private static final List<String> GLOBAL_TEMPLATES = Stream.of("brainstormingTemplate", "eventPlanningTemplate", "projectManagementTemplate", "retrospectiveTemplate", "sprintPlanningTemplate", "userStoryMappingTemplate").collect(Collectors.toList());
    private static final String BANDANA_MANAGER_KEY_TEMPLATES = "cz.morosystems.namymap.model.template.all";
    private static final String TEMPLATES_MIGRATED_TO_ACTIVE_OBJECTS = "templates-migrated-to-active-objects";
    private final ActiveObjects activeObjects;
    private final PluginSettings pluginSettings;
    private final BandanaManager bandanaManager;

    @Autowired
    public MindMapTemplateServiceImpl(@ComponentImport @NonNull ActiveObjects activeObjects, @ComponentImport @NonNull BandanaManager bandanaManager, @ComponentImport @NonNull PluginSettingsFactory psf) {
        if (activeObjects == null) {
            throw new NullPointerException("activeObjects");
        }
        if (bandanaManager == null) {
            throw new NullPointerException("bandanaManager");
        }
        if (psf == null) {
            throw new NullPointerException("psf");
        }
        this.activeObjects = activeObjects;
        this.bandanaManager = bandanaManager;
        this.pluginSettings = psf.createGlobalSettings();
    }

    private NamymapTemplate convertAoToModel(MindMapTemplateAo ao) {
        NamymapTemplate template = new NamymapTemplate();
        template.setKey(ao.getKey());
        template.setName(ao.getName());
        template.setMap(ao.getJson());
        template.setOwner(ao.getOwner());
        template.setShared(ao.getShared());
        template.setCreated(ao.getDate());
        return template;
    }

    @Override
    public List<NamymapTemplate> getAllTemplates() {
        MindMapTemplateAo[] results = (MindMapTemplateAo[])this.activeObjects.find(MindMapTemplateAo.class);
        return Arrays.stream(results).filter(this::hasReadPermissions).peek(templateEntity -> {
            if (!this.hasWritePermissions((MindMapTemplateAo)templateEntity)) {
                templateEntity.setOwner(null);
            }
        }).map(this::convertAoToModel).sorted((o1, o2) -> StringUtils.compareIgnoreCase(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    @Override
    public TemplateDto createOrUpdateTemplate(String key, String name, String mindMap, Boolean shared) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String updatedKey = StringUtils.isBlank(key) ? this.createTemplate(name, mindMap, shared, confluenceUser.getKey().getStringValue()) : this.updateTemplate(key, name, mindMap);
        return TemplateDto.builder().key(updatedKey).build();
    }

    private String createTemplate(String name, String json, Boolean shared, String owner) {
        Validate.notBlank(name);
        return (String)this.activeObjects.executeInTransaction(() -> {
            String hashBase = name + new Date().getTime();
            String key = String.valueOf(hashBase.hashCode());
            MindMapTemplateAo templateAo = AoUtil.getByKeyOrCreate(this.activeObjects, MindMapTemplateAo.class, key);
            templateAo.setName(name);
            templateAo.setJson(json);
            templateAo.setShared(shared);
            templateAo.setOwner(owner);
            templateAo.setDate(new Date());
            templateAo.save();
            return key;
        });
    }

    private String updateTemplate(String key, String name, String json) {
        Validate.notBlank(key);
        return (String)this.activeObjects.executeInTransaction(() -> {
            Optional<MindMapTemplateAo> result = AoUtil.getByKey(this.activeObjects, MindMapTemplateAo.class, key);
            if (!result.isPresent()) {
                return key;
            }
            MindMapTemplateAo templateAo = result.get();
            Validate.isTrue(this.hasReadPermissions(templateAo), "User does not have required permission for reading template.", new Object[0]);
            if (!StringUtils.isBlank(name)) {
                templateAo.setName(name);
            }
            templateAo.setJson(json);
            templateAo.save();
            return key;
        });
    }

    @Override
    public AttachmentLoadObject getTemplateAttachmentLoadObject(String key) throws IOException {
        Validate.notBlank(key);
        NamymapTemplate template = this.getTemplate(key);
        AttachmentObject templateFile = new AttachmentObject();
        templateFile.setDate(new Date());
        templateFile.setFileVersion("0");
        templateFile.setJson(template.getMap());
        return AttachmentLoadObject.fromAttachmentObject(templateFile);
    }

    @Override
    public NamymapTemplate getTemplate(String key) {
        if (StringUtils.isBlank(key)) {
            log.error("Parameter 'key' is required.");
            return null;
        }
        return this.getGlobalTemplate(key).orElseGet(() -> AoUtil.getByKey(this.activeObjects, MindMapTemplateAo.class, key).map(this::convertAoToModel).orElse(null));
    }

    private Optional<NamymapTemplate> getGlobalTemplate(String key) {
        if (!GLOBAL_TEMPLATES.contains(key)) {
            return Optional.empty();
        }
        try {
            String json = EasyMindVersionConverter.convertFromInputStream(this.getClass().getClassLoader().getResourceAsStream("mind-map-templates/" + key + ".json"));
            NamymapTemplate template = new NamymapTemplate();
            template.setMap(json);
            template.setKey(key);
            template.setShared(true);
            template.setCreated(new Date());
            return Optional.of(template);
        }
        catch (IOException | NullPointerException e) {
            log.error("Cannot load global template: " + key, (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void deleteTemplate(String key) {
        if (StringUtils.isBlank(key)) {
            log.error("Parameter 'key' is required.");
            return;
        }
        AoUtil.getByKey(this.activeObjects, MindMapTemplateAo.class, key).ifPresent(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public void renameTemplate(String key, String name) {
        if (StringUtils.isBlank(key) || StringUtils.isBlank(name)) {
            log.error("Parameters key = {}, name = {} are required.", (Object)key, (Object)name);
            return;
        }
        this.activeObjects.executeInTransaction(() -> {
            Optional<MindMapTemplateAo> result = AoUtil.getByKey(this.activeObjects, MindMapTemplateAo.class, key);
            if (!result.isPresent()) {
                log.error("MindMap template with key = {} does not exist.", (Object)key);
                return null;
            }
            MindMapTemplateAo templateAo = result.get();
            templateAo.setName(name);
            templateAo.save();
            return null;
        });
    }

    @Override
    public Set<NamymapTemplate> getAllTemplatesForCloudMigration() {
        MindMapTemplateAo[] results = (MindMapTemplateAo[])this.activeObjects.find(MindMapTemplateAo.class);
        return Arrays.stream(results).map(this::convertAoToModel).collect(Collectors.toSet());
    }

    @Override
    public void migrateTemplatesToActiveObjects() {
        Object templatesMigrated = this.pluginSettings.get(TEMPLATES_MIGRATED_TO_ACTIVE_OBJECTS);
        if (templatesMigrated != null) {
            log.info("Templates migration already done. Skipping.");
            return;
        }
        Object templatesObject = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, BANDANA_MANAGER_KEY_TEMPLATES);
        if (!(templatesObject instanceof HashMap)) {
            log.error("Error casting templates from EasyMind version 1.x. Skipping.");
            return;
        }
        log.info("Templates migration started.");
        try {
            HashMap templates = (HashMap)templatesObject;
            this.activeObjects.executeInTransaction(() -> {
                templates.entrySet().stream().filter(entry -> !GLOBAL_TEMPLATES.contains(entry.getKey())).forEach(entry -> {
                    Map templateObject = new ObjectMapper().convertValue(entry.getValue(), Map.class);
                    MindMapTemplateAo templateAo = AoUtil.getByKeyOrCreate(this.activeObjects, MindMapTemplateAo.class, (String)entry.getKey());
                    templateAo.setName((String)templateObject.get("name"));
                    templateAo.setJson((String)templateObject.get("map"));
                    templateAo.setShared(templateObject.get("shared") == null || (Boolean)templateObject.get("shared") != false);
                    templateAo.setOwner((String)templateObject.get("owner"));
                    templateAo.setDate(templateObject.get("created") == null ? null : new Date((Long)templateObject.get("created")));
                    templateAo.save();
                });
                this.pluginSettings.put(TEMPLATES_MIGRATED_TO_ACTIVE_OBJECTS, (Object)TEMPLATES_MIGRATED_TO_ACTIVE_OBJECTS);
                log.info("Templates migration finished.");
                return null;
            });
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            log.error("Error casting templates from older version of EasyMind. Skipping.");
        }
    }

    private boolean hasReadPermissions(@NonNull MindMapTemplateAo template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        return this.isOwner(template) || template.getShared() == null || template.getShared() != false;
    }

    private boolean hasWritePermissions(@NonNull MindMapTemplateAo template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        return this.isOwner(template);
    }

    private boolean isOwner(@NonNull MindMapTemplateAo template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return StringUtils.equalsIgnoreCase(template.getOwner(), confluenceUser.getKey().getStringValue());
    }
}

