/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.server.autosave.AutoSaveData;
import cz.morosystems.namymap.server.model.AttachmentObject;
import cz.morosystems.namymap.server.model.ao.MindMapDraftAo;
import cz.morosystems.namymap.server.service.MindMapDraftService;
import cz.morosystems.namymap.server.service.dto.migration.DraftMigrationDto;
import cz.morosystems.namymap.server.utils.AoUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class MindMapDraftServiceImpl
implements MindMapDraftService {
    private static final Logger log = LoggerFactory.getLogger(MindMapDraftServiceImpl.class);
    private static final String DRAFTS_MIGRATED_TO_ACTIVE_OBJECTS = "drafts-migrated-to-active-objects";
    private final ActiveObjects activeObjects;
    private final PluginSettings pluginSettings;
    private final BandanaManager bandanaManager;
    private final BandanaContext context = new ConfluenceBandanaContext("cz.morosystems.namymap.namymap-context");

    @Autowired
    public MindMapDraftServiceImpl(@ComponentImport @NonNull ActiveObjects activeObjects, @ComponentImport @NonNull BandanaManager bandanaManager, @ComponentImport @NonNull PluginSettingsFactory psf) {
        if (activeObjects == null) {
            throw new NullPointerException("activeObjects");
        }
        if (bandanaManager == null) {
            throw new NullPointerException("bandanaManager");
        }
        if (psf == null) {
            throw new NullPointerException("psf");
        }
        this.activeObjects = activeObjects;
        this.bandanaManager = bandanaManager;
        this.pluginSettings = psf.createGlobalSettings();
    }

    @Override
    public void saveDraft(String userName, AutoSaveData autoSaveData) {
        this.activeObjects.executeInTransaction(() -> {
            MindMapDraftAo mindMapDraftAo = AoUtil.getByKeyOrCreate(this.activeObjects, MindMapDraftAo.class, autoSaveData.getKey());
            mindMapDraftAo.setDate(new Date());
            mindMapDraftAo.setJson(autoSaveData.getContent());
            mindMapDraftAo.save();
            return null;
        });
    }

    @Override
    public AttachmentObject getDraft(String userName, AutoSaveData autoSaveData) {
        Optional<MindMapDraftAo> result = AoUtil.getByKey(this.activeObjects, MindMapDraftAo.class, autoSaveData.getKey());
        return result.map(mindMapDraftAo -> new AttachmentObject(mindMapDraftAo.getDate(), mindMapDraftAo.getJson(), mindMapDraftAo.getFileVersion())).orElse(null);
    }

    @Override
    public void deleteDraft(String userName, AutoSaveData autoSaveData) {
        AoUtil.getByKey(this.activeObjects, MindMapDraftAo.class, autoSaveData.getKey()).ifPresent(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public void processAutoSavedVersion(String userName, Long pageId, String jsonFileName, String originalVersion) {
        AutoSaveData pageAutoSave = new AutoSaveData(userName, jsonFileName, null, pageId);
        AttachmentObject autoSavedVersion = this.getDraft(userName, pageAutoSave);
        if (MindMapDraftServiceImpl.isSameVersion(originalVersion, autoSavedVersion)) {
            this.deleteDraft(userName, pageAutoSave);
        }
    }

    @Override
    public Set<DraftMigrationDto> getDraftsForCloudMigration(String userName) {
        String searchPattern = "%|" + userName + "|" + "%";
        MindMapDraftAo[] userDrafts = (MindMapDraftAo[])this.activeObjects.find(MindMapDraftAo.class, Query.select().where("KEY like ?", new Object[]{searchPattern}));
        return Arrays.stream(userDrafts).map(result -> {
            AutoSaveData autoSaveData = AutoSaveData.fromKey(result.getKey(), null);
            if (autoSaveData == null) {
                return null;
            }
            return new DraftMigrationDto(autoSaveData.getPageId(), autoSaveData.getName(), result.getJson(), result.getDate());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void migrateDraftsToActiveObjects() {
        Object draftsMigrated = this.pluginSettings.get(DRAFTS_MIGRATED_TO_ACTIVE_OBJECTS);
        if (draftsMigrated != null) {
            log.info("Drafts migration already done. Skipping.");
            return;
        }
        this.activeObjects.executeInTransaction(() -> {
            log.info("Drafts migration started.");
            this.bandanaManager.getKeys(this.context).forEach(key -> {
                try {
                    Map draftObject = new ObjectMapper().convertValue(this.bandanaManager.getValue(this.context, key), Map.class);
                    MindMapDraftAo mindMapDraftAo = AoUtil.getByKeyOrCreate(this.activeObjects, MindMapDraftAo.class, key);
                    mindMapDraftAo.setJson((String)draftObject.get("json"));
                    mindMapDraftAo.setDate(draftObject.get("date") == null ? null : new Date((Long)draftObject.get("date")));
                    mindMapDraftAo.setFileVersion((String)draftObject.get("fileVersion"));
                    mindMapDraftAo.save();
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
                    log.error("Error casting draft from older version of EasyMind. Skipping.");
                }
            });
            this.pluginSettings.put(DRAFTS_MIGRATED_TO_ACTIVE_OBJECTS, (Object)DRAFTS_MIGRATED_TO_ACTIVE_OBJECTS);
            log.info("Drafts migration finished.");
            return null;
        });
    }

    private static boolean isSameVersion(String originalVersion, AttachmentObject autoSavedVersion) {
        return CommonUtil.isMindmapContentSame(originalVersion, autoSavedVersion != null ? autoSavedVersion.getJson() : null);
    }
}

