/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.impl;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.morosystems.namymap.server.service.MindMapDraftService;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import cz.morosystems.namymap.server.service.dto.migration.DraftMigrationDto;
import cz.morosystems.namymap.server.service.dto.migration.DraftsByUserMigrationDto;
import cz.morosystems.namymap.server.service.dto.migration.TemplateMigrationDto;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class CloudMigrationServiceImpl
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(CloudMigrationServiceImpl.class);
    private static final int PAGE_SIZE = 50;
    private final UserManager userManager;
    private final MindMapDraftService mindMapDraftService;
    private final MindMapTemplateService mindMapTemplateService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public CloudMigrationServiceImpl(@ComponentImport @NonNull UserManager userManager, @NonNull MindMapDraftService mindMapDraftService, @NonNull MindMapTemplateService mindMapTemplateService, @NonNull TransactionTemplate transactionTemplate) {
        if (userManager == null) {
            throw new NullPointerException("userManager");
        }
        if (mindMapDraftService == null) {
            throw new NullPointerException("mindMapDraftService");
        }
        if (mindMapTemplateService == null) {
            throw new NullPointerException("mindMapTemplateService");
        }
        if (transactionTemplate == null) {
            throw new NullPointerException("transactionTemplate");
        }
        log.info("Migration service created");
        this.mindMapTemplateService = mindMapTemplateService;
        this.mindMapDraftService = mindMapDraftService;
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        this.transactionTemplate.execute(() -> {
            log.info("Migration started {}", (Object)transferId);
            try {
                this.mindMapTemplateService.getAllTemplatesForCloudMigration().stream().map(template -> new TemplateMigrationDto(template.getKey(), template.getName(), template.getMap(), template.getOwner(), template.getShared())).forEach(template -> {
                    try (OutputStream firstDataStream = gateway.createAppData(transferId, "templates");){
                        log.info("Template {} migration", (Object)template.getTemplateName());
                        firstDataStream.write(new ObjectMapper().writeValueAsString(template).getBytes());
                    }
                    catch (IOException e) {
                        log.error("Error uploading files to the cloud", (Throwable)e);
                    }
                });
                PaginatedMapping users = gateway.getPaginatedMapping(transferId, "identity:user", 50);
                Map<String, String> pages = this.getAllPagesMapping(gateway, transferId);
                while (users.next()) {
                    users.getMapping().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("confluence.userkey")).map(entry -> {
                        String serverUserKey = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(47) + 1);
                        UserProfile userProfile = this.userManager.getUserProfile(new UserKey(serverUserKey));
                        return userProfile == null ? null : new DraftsByUserMigrationDto((String)entry.getValue(), this.getAllDraftsByUser(userProfile.getUsername(), pages));
                    }).filter(Objects::nonNull).forEach(autoSaveData -> {
                        try (OutputStream firstDataStream = gateway.createAppData(transferId, "drafts");){
                            firstDataStream.write(new ObjectMapper().writeValueAsString(autoSaveData).getBytes());
                        }
                        catch (IOException e) {
                            log.error("Error uploading files to the cloud", (Throwable)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("Migration failed", (Throwable)e);
            }
            log.info("Migration finished");
            return null;
        });
    }

    private Map<String, String> getAllPagesMapping(AppCloudMigrationGateway gateway, String transferId) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        PaginatedMapping pages = gateway.getPaginatedMapping(transferId, "confluence:page", 50);
        while (pages.next()) {
            mappings.putAll(pages.getMapping());
        }
        return mappings;
    }

    private Set<DraftMigrationDto> getAllDraftsByUser(String serverUsername, Map<String, String> pageMappings) {
        return this.mindMapDraftService.getDraftsForCloudMigration(serverUsername).stream().map(draftDto -> {
            String cloudPageId = (String)pageMappings.get(String.valueOf(draftDto.getPageId()));
            if (cloudPageId == null) {
                return null;
            }
            draftDto.setPageId(Long.parseLong(cloudPageId));
            return draftDto;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public String getCloudAppKey() {
        return "cz.morosystems.atlassian.plugin.easymind";
    }

    @Override
    public String getServerAppKey() {
        return "cz.morosystems.atlassian.plugin.easymind";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_UGC, AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_UGC, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }
}

