/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.service.dto;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDto {
    private static final Logger log = LoggerFactory.getLogger(SearchDto.class);
    private static final String URL_PAGE_ID_PATTERN_STR = "(.*)pageId=([0-9]*)(.*)";
    private static final Pattern URL_PAGE_ID_PATTERN = Pattern.compile("(.*)pageId=([0-9]*)(.*)");
    private Integer totalCount;
    private List<AttachmentDto> data;

    public static SearchDto fromSearchResults(List<SearchResult> searchResults, ConfluenceUser confluenceUser) {
        return SearchDto.builder().totalCount(searchResults.size()).data(SearchDto.createData(searchResults, confluenceUser)).build();
    }

    private static List<AttachmentDto> createData(List<SearchResult> searchResults, ConfluenceUser confluenceUser) {
        Validate.notNull(searchResults);
        Validate.notNull(confluenceUser);
        return searchResults.stream().filter(searchResult -> ContentTypeEnum.ATTACHMENT == ContentTypeEnum.getByRepresentation((String)searchResult.getType())).filter(searchResult -> NamymapPermissionManager.canWriteMapModelToPage(SearchDto.getAttachmentPageId(searchResult), (User)confluenceUser)).map(searchResult -> new AttachmentDto(searchResult.getDisplayTitle(), SearchDto.getAttachmentPageId(searchResult))).collect(Collectors.toList());
    }

    private static long getAttachmentPageId(SearchResult searchResult) {
        Validate.notNull(searchResult);
        Matcher matcher = URL_PAGE_ID_PATTERN.matcher(searchResult.getUrlPath());
        if (matcher.matches()) {
            try {
                return Long.parseLong(matcher.group(2));
            }
            catch (NumberFormatException e) {
                log.error("Unable to obtain page ID from attachment url: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    SearchDto(Integer totalCount, List<AttachmentDto> data) {
        this.totalCount = totalCount;
        this.data = data;
    }

    public static SearchDtoBuilder builder() {
        return new SearchDtoBuilder();
    }

    private SearchDto() {
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public List<AttachmentDto> getData() {
        return this.data;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setData(List<AttachmentDto> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDto)) {
            return false;
        }
        SearchDto other = (SearchDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        List<AttachmentDto> this$data = this.getData();
        List<AttachmentDto> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        List<AttachmentDto> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "SearchDto(totalCount=" + this.getTotalCount() + ", data=" + this.getData() + ")";
    }

    public static class SearchDtoBuilder {
        private Integer totalCount;
        private List<AttachmentDto> data;

        SearchDtoBuilder() {
        }

        public SearchDtoBuilder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public SearchDtoBuilder data(List<AttachmentDto> data) {
            this.data = data;
            return this;
        }

        public SearchDto build() {
            return new SearchDto(this.totalCount, this.data);
        }

        public String toString() {
            return "SearchDto.SearchDtoBuilder(totalCount=" + this.totalCount + ", data=" + this.data + ")";
        }
    }

    public static class AttachmentDto {
        private String name;
        private Long pageId;

        public String getName() {
            return this.name;
        }

        public Long getPageId() {
            return this.pageId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPageId(Long pageId) {
            this.pageId = pageId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttachmentDto)) {
                return false;
            }
            AttachmentDto other = (AttachmentDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Long this$pageId = this.getPageId();
            Long other$pageId = other.getPageId();
            return !(this$pageId == null ? other$pageId != null : !((Object)this$pageId).equals(other$pageId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttachmentDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Long $pageId = this.getPageId();
            result = result * 59 + ($pageId == null ? 43 : ((Object)$pageId).hashCode());
            return result;
        }

        public String toString() {
            return "SearchDto.AttachmentDto(name=" + this.getName() + ", pageId=" + this.getPageId() + ")";
        }

        public AttachmentDto(String name, Long pageId) {
            this.name = name;
            this.pageId = pageId;
        }
    }
}

