/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.search;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchResult;
import cz.morosystems.namymap.server.model.ContentSearchResult;
import cz.morosystems.namymap.server.search.AttachmentSearchTransformer;
import cz.morosystems.namymap.server.search.PageSearchTransformer;
import cz.morosystems.namymap.server.search.SearchTransformer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSearchTransformer {
    private static final Logger log = LoggerFactory.getLogger(ContentSearchTransformer.class);
    private final SearchTransformer pageTransformer = new PageSearchTransformer();
    private final SearchTransformer attachmentTransformer = new AttachmentSearchTransformer();

    public Set<ContentSearchResult> transform(List<SearchResult> searchResult) {
        TreeSet<ContentSearchResult> resultList = new TreeSet<ContentSearchResult>(new Comparator<ContentSearchResult>(){

            @Override
            public int compare(ContentSearchResult search1, ContentSearchResult search2) {
                return search1.getPageId().compareTo(search2.getPageId());
            }
        });
        for (SearchResult result : searchResult) {
            String type = result.getField("type");
            if (ContentTypeEnum.PAGE.getRepresentation().equals(type)) {
                resultList.add(this.pageTransformer.transform(result));
                continue;
            }
            if (ContentTypeEnum.ATTACHMENT.getRepresentation().equals(type)) {
                resultList.add(this.attachmentTransformer.transform(result));
                continue;
            }
            log.error("Unknown searched content type: " + type);
        }
        return resultList;
    }
}

