/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.rest;

import com.google.gson.Gson;
import cz.morosystems.namymap.common.dto.EnumDto;
import cz.morosystems.namymap.common.service.EnumService;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/enums")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class EnumRest {
    private static final Logger log = LoggerFactory.getLogger(EnumRest.class);
    private final EnumService enumService;

    @Autowired
    public EnumRest(@NonNull EnumService enumService) {
        if (enumService == null) {
            throw new NullPointerException("enumService");
        }
        this.enumService = enumService;
    }

    @GET
    public Response getAppEnumeration() {
        Map<String, List<EnumDto>> enums = this.enumService.getAllEnums();
        return Response.ok((Object)new Gson().toJson(enums)).build();
    }
}

