/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.permission;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.permission.EditableObject;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import cz.morosystems.namymap.server.utils.NamymapUtil;

public class PageEditObject
implements EditableObject {
    private final Long pageId;

    public PageEditObject(Long pageId) {
        this.pageId = pageId;
    }

    @Override
    public Permission getRequiredPermission() {
        return Permission.EDIT;
    }

    @Override
    public void checkUserPermission(User currentUser) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(this.pageId);
        if (!NamymapPermissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), ceo, this.getRequiredPermission())) {
            throw new NamymapSecurityException("User does not have required permission: " + this.getRequiredPermission());
        }
    }
}

