/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.permission;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.autosave.AutoSaveData;
import cz.morosystems.namymap.server.utils.NamymapUtil;

public class NamymapPermissionManager {
    private static final PermissionManager permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager", PermissionManager.class);

    private NamymapPermissionManager() {
    }

    public static boolean hasPermission(User user, ContentEntityObject ceo, Permission requiredPermission) {
        return permissionManager.hasPermission(user, requiredPermission, (Object)ceo);
    }

    public static boolean isConfluenceAdministrator(User user) {
        return permissionManager.isConfluenceAdministrator(user);
    }

    public static void checkSaveAutoSavePermission(User user, AutoSaveData autoSave) {
        NamymapPermissionManager.checkAutoSavePermission(user, autoSave, "User does not have required permission for saving autosave: ");
    }

    public static void checkLoadAutoSavePermission(User user, AutoSaveData autoSave) {
        NamymapPermissionManager.checkAutoSavePermission(user, autoSave, "User does not have required permission for loading autosave: ");
    }

    public static void checkDeleteAutoSavePermission(User user, AutoSaveData autoSave) {
        NamymapPermissionManager.checkAutoSavePermission(user, autoSave, "User does not have required permission for deleting autosave: ");
    }

    private static void checkAutoSavePermission(User user, AutoSaveData autoSave, String securityExceptionMessage) {
        Permission requiredPermission = Permission.EDIT;
        boolean hasPermission = NamymapPermissionManager.hasPermission(user, NamymapUtil.getContentEntityObject(autoSave.getPageId()), requiredPermission);
        if (!hasPermission) {
            throw new NamymapSecurityException(securityExceptionMessage + requiredPermission);
        }
    }

    public static boolean canReadMapModelFromPage(ContentEntityObject page, User user) {
        return permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }

    public static boolean canReadMapModelFromPage(long ceoId, User user) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(ceoId);
        return NamymapPermissionManager.canReadMapModelFromPage(ceo, user);
    }

    public static boolean canReadMapModelFromPage(String ceoId, User user) {
        return NamymapPermissionManager.canReadMapModelFromPage(Long.parseLong(ceoId), user);
    }

    public static boolean canWriteMapModelToPage(ContentEntityObject page, User user) {
        boolean canWrite = permissionManager.hasPermission(user, Permission.EDIT, (Object)page);
        boolean canAttach = true;
        return canAttach && canWrite;
    }

    public static boolean canWriteMapModelToPage(long ceoId, User user) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(ceoId);
        return NamymapPermissionManager.canWriteMapModelToPage(ceo, user);
    }

    public static boolean canWriteMapModelToPage(String ceoId, User user) {
        return NamymapPermissionManager.canWriteMapModelToPage(Long.parseLong(ceoId), user);
    }

    public static boolean canAttachMapToPage(ContentEntityObject page, User user) {
        return permissionManager.hasCreatePermission(user, (Object)page, Attachment.class);
    }

    public static boolean canAttachMapToPage(long ceoId, User user) {
        ContentEntityObject ceo = NamymapUtil.getContentEntityObject(ceoId);
        return NamymapPermissionManager.canAttachMapToPage(ceo, user);
    }

    public static boolean canAttachMapToPage(String ceoId, User user) {
        return NamymapPermissionManager.canAttachMapToPage(Long.parseLong(ceoId), user);
    }
}

