/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.model;

import com.atlassian.confluence.core.ContentEntityObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MindmapStorage {
    private final long pageId;
    private final String mindmapName;

    public static MindmapStorage fromMacroParams(Map<String, String> params, ContentEntityObject originalPage) {
        String externalPageId = params.get("modelPageId");
        String externalMindmapName = params.get("modelFN");
        if (!StringUtils.isBlank(externalPageId) && !StringUtils.isBlank(externalMindmapName)) {
            return new MindmapStorage(Long.parseLong(externalPageId), externalMindmapName);
        }
        String mindmapName = params.get("name");
        return new MindmapStorage(originalPage.getId(), mindmapName);
    }

    public long getPageId() {
        return this.pageId;
    }

    public String getMindmapName() {
        return this.mindmapName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MindmapStorage)) {
            return false;
        }
        MindmapStorage other = (MindmapStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageId() != other.getPageId()) {
            return false;
        }
        String this$mindmapName = this.getMindmapName();
        String other$mindmapName = other.getMindmapName();
        return !(this$mindmapName == null ? other$mindmapName != null : !this$mindmapName.equals(other$mindmapName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MindmapStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageId = this.getPageId();
        result = result * 59 + (int)($pageId >>> 32 ^ $pageId);
        String $mindmapName = this.getMindmapName();
        result = result * 59 + ($mindmapName == null ? 43 : $mindmapName.hashCode());
        return result;
    }

    public String toString() {
        return "MindmapStorage(pageId=" + this.getPageId() + ", mindmapName=" + this.getMindmapName() + ")";
    }

    public MindmapStorage(long pageId, String mindmapName) {
        this.pageId = pageId;
        this.mindmapName = mindmapName;
    }
}

