/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.macro.easymind;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import cz.morosystems.namymap.common.CommonUtil;
import cz.morosystems.namymap.common.expimp.freeplane.guts.FreePlaneParser;
import cz.morosystems.namymap.server.macro.easymind.EasyMindMacro;
import cz.morosystems.namymap.server.model.EditorParametersDto;
import cz.morosystems.namymap.server.model.LegacyExternalStorage;
import cz.morosystems.namymap.server.model.MindmapStorage;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import cz.morosystems.namymap.server.service.LicenseService;
import cz.morosystems.namymap.server.utils.NamymapUtil;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyMindMacroDisplay {
    private static final Logger log = LoggerFactory.getLogger(EasyMindMacroDisplay.class);
    private final LicenseService licenseService;
    private final boolean export;

    public EasyMindMacroDisplay(LicenseService licenseService) {
        this(licenseService, false);
    }

    public EasyMindMacroDisplay(LicenseService licenseService, boolean export) {
        this.licenseService = licenseService;
        this.export = export;
    }

    public String execute(Map<String, String> params, String bodyContent, ConversionContext context, EasyMindMacro macro) {
        ContentEntityObject displayPage = macro.getPage(context);
        String widthParam = params.get("width");
        MindmapStorage mindmapStorage = MindmapStorage.fromMacroParams(params, displayPage);
        Attachment pngAttachment = macro.getImageAttachment(mindmapStorage.getPageId(), mindmapStorage.getMindmapName());
        String pngUrl = null;
        if (pngAttachment != null) {
            pngUrl = pngAttachment.getDownloadPath();
        }
        Attachment model = macro.getModelAttachment(mindmapStorage.getPageId(), mindmapStorage.getMindmapName());
        Map<String, Object> contextMap = this.initContext(mindmapStorage, displayPage, params.get("name"), macro);
        NamymapUtil.setMacroWidthToContextMap(contextMap, widthParam, pngAttachment);
        contextMap.put("pngUrl", pngUrl);
        contextMap.put("hasModel", model != null);
        contextMap.put("licenseOK", this.licenseService.getLicense().isValid());
        if (this.export) {
            return VelocityUtils.getRenderedTemplate((String)"templates/macro/page-export-macro.vm", contextMap);
        }
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/page-view-macro.vm", contextMap);
    }

    private Map<String, Object> initContext(@NonNull MindmapStorage mindmapStorage, @NonNull ContentEntityObject displayPage, @NonNull String displayMindmapName, @NonNull EasyMindMacro macro) {
        if (mindmapStorage == null) {
            throw new NullPointerException("mindmapStorage");
        }
        if (displayPage == null) {
            throw new NullPointerException("displayPage");
        }
        if (displayMindmapName == null) {
            throw new NullPointerException("displayMindmapName");
        }
        if (macro == null) {
            throw new NullPointerException("macro");
        }
        Map<String, Object> contextMap = macro.initVelocityContext();
        contextMap.put("pageId", displayPage.getIdAsString());
        contextMap.put("mindmapName", CommonUtil.truncateMindmanName(displayMindmapName));
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String baseURL = (String)contextMap.get("webAppContextPath");
        String lastPageAttr = baseURL + displayPage.getUrlPath();
        EditorParametersDto.EditorParametersDtoBuilder namymapEditorActionParamsBuilder = EditorParametersDto.builder().pageId(String.valueOf(displayPage.getId())).mindmapName(this.getEscapedMindmapName(displayMindmapName)).lastPage(lastPageAttr).legacyExternalStorage(this.getLegacyExternalStorageOrNull(mindmapStorage, displayPage, displayMindmapName));
        if (user != null && NamymapPermissionManager.canWriteMapModelToPage(mindmapStorage.getPageId(), (User)user)) {
            String editorURL = NamymapUtil.generateShowEditorURL(baseURL, namymapEditorActionParamsBuilder.isViewMode(false).build());
            contextMap.put("showEditorButton", true);
            contextMap.put("editorURL", editorURL);
            String removeURL = NamymapUtil.generateRemoveURL(baseURL, lastPageAttr, displayPage.getId(), displayMindmapName);
            contextMap.put("showRemoveButton", true);
            contextMap.put("removeBtn", FreePlaneParser.randomID(5));
            contextMap.put("removeActionURL", removeURL);
        }
        if (NamymapPermissionManager.canReadMapModelFromPage(mindmapStorage.getPageId(), (User)user)) {
            String readonlyEditorURL = NamymapUtil.generateShowEditorURL(baseURL, namymapEditorActionParamsBuilder.isViewMode(true).build());
            contextMap.put("readonlyEditorURL", readonlyEditorURL);
            contextMap.put("showViewButton", user != null);
        }
        return contextMap;
    }

    private LegacyExternalStorage getLegacyExternalStorageOrNull(MindmapStorage mindmapStorage, ContentEntityObject displayPage, String displayMindmapName) {
        if (mindmapStorage.getPageId() == displayPage.getId() && mindmapStorage.getMindmapName().equals(displayMindmapName)) {
            return null;
        }
        return new LegacyExternalStorage(mindmapStorage.getPageId(), mindmapStorage.getMindmapName());
    }

    private String getEscapedMindmapName(String mindmapName) {
        Validate.notBlank(mindmapName);
        return StringEscapeUtils.escapeJava(mindmapName);
    }
}

