/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence.action;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import cz.morosystems.namymap.common.enums.EditorMode;
import cz.morosystems.namymap.server.confluence.action.NamymapEditorAction;
import cz.morosystems.namymap.server.service.ContentService;
import cz.morosystems.namymap.server.service.LicenseService;
import cz.morosystems.namymap.server.service.UserService;
import java.util.Base64;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NamymapRemoveAction
extends NamymapEditorAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(NamymapRemoveAction.class);
    private static final long serialVersionUID = -2136179415495851905L;
    private AbstractPage page;
    private final transient ContentService contentService;

    @Override
    @StrutsParameter
    public void setPageId(String pageId) {
        super.setPageId(pageId);
    }

    @Override
    @StrutsParameter
    public void setMindmapName(String mindmapName) {
        super.setMindmapName(mindmapName);
    }

    @Override
    @StrutsParameter
    public void setLastPage(String lastPage) {
        super.setLastPage(lastPage);
    }

    @Override
    @StrutsParameter
    public void setIsViewMode(String isViewMode) {
        super.setIsViewMode(isViewMode);
    }

    @Override
    @StrutsParameter
    public void setIsCopyMode(String isCopyMode) {
        super.setIsCopyMode(isCopyMode);
    }

    @Override
    @StrutsParameter
    public void setIsImportMode(String isImportMode) {
        super.setIsImportMode(isImportMode);
    }

    @Override
    @StrutsParameter
    public void setIsEditorMode(String isEditorMode) {
        super.setIsEditorMode(isEditorMode);
    }

    @Override
    @StrutsParameter
    public void setEditorMode(EditorMode editorMode) {
        super.setEditorMode(editorMode);
    }

    @Override
    @StrutsParameter
    public void setLegacyExternalStoragePageId(Long legacyExternalStoragePageId) {
        super.setLegacyExternalStoragePageId(legacyExternalStoragePageId);
    }

    @Override
    @StrutsParameter
    public void setLegacyExternalStorageMindmapName(String legacyExternalStorageMindmapName) {
        super.setLegacyExternalStorageMindmapName(legacyExternalStorageMindmapName);
    }

    @Override
    @StrutsParameter
    public void setMindmapPreloadPageId(Long mindmapPreloadPageId) {
        super.setMindmapPreloadPageId(mindmapPreloadPageId);
    }

    @Override
    @StrutsParameter
    public void setMindmapPreloadMindmapName(String mindmapPreloadMindmapName) {
        super.setMindmapPreloadMindmapName(mindmapPreloadMindmapName);
    }

    @Override
    public void setTemplateKey(String templateKey) {
        super.setTemplateKey(templateKey);
    }

    @Override
    @StrutsParameter
    public void setTemplateAction(String templateAction) {
        super.setTemplateAction(templateAction);
    }

    @Override
    @StrutsParameter
    public void setContextPath(String contextPath) {
        super.setContextPath(contextPath);
    }

    @Override
    @StrutsParameter
    public void setMacroName(String macroName) {
        super.setMacroName(macroName);
    }

    @Override
    @StrutsParameter
    public void setIsReadOnly(String isReadOnly) {
        super.setIsReadOnly(isReadOnly);
    }

    @Override
    @StrutsParameter
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Autowired
    public NamymapRemoveAction(@NonNull LicenseService licenseService, @NonNull UserService userService, @NonNull ContentService contentService, @ComponentImport @NonNull WebResourceAssemblerFactory webResourceAssemblerFactory, @ComponentImport @NonNull BootstrapManager bootstrapManager) {
        super(licenseService, userService, webResourceAssemblerFactory, bootstrapManager);
        if (licenseService == null) {
            throw new NullPointerException("licenseService");
        }
        if (userService == null) {
            throw new NullPointerException("userService");
        }
        if (contentService == null) {
            throw new NullPointerException("contentService");
        }
        if (webResourceAssemblerFactory == null) {
            throw new NullPointerException("webResourceAssemblerFactory");
        }
        if (bootstrapManager == null) {
            throw new NullPointerException("bootstrapManager");
        }
        this.contentService = contentService;
    }

    @Override
    public String execute() throws Exception {
        log.info("Execute action:" + this.getPageId());
        this.removeMacro();
        return "success";
    }

    @Override
    public String getActionName() {
        return "NamymapRemoveAction";
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    private void removeMacro() {
        this.contentService.removeMacroFromPage(Long.parseLong(this.getPageId()), this.getMindmapName());
        this.contentService.removeMacroFromPageComments(Long.parseLong(this.getPageId()), this.getMindmapName());
    }

    @Override
    public String getMindmapName() {
        Validate.notBlank(super.getMindmapName());
        return new String(Base64.getUrlDecoder().decode(super.getMindmapName()));
    }
}

