/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import cz.morosystems.namymap.common.enums.EditorMode;
import cz.morosystems.namymap.common.exception.NamymapSecurityException;
import cz.morosystems.namymap.server.confluence.action.EditorModeFactory;
import cz.morosystems.namymap.server.model.EditorParametersDto;
import cz.morosystems.namymap.server.permission.NamymapPermissionManager;
import cz.morosystems.namymap.server.permission.PageEditObject;
import cz.morosystems.namymap.server.permission.TemplateEditObject;
import cz.morosystems.namymap.server.service.LicenseService;
import cz.morosystems.namymap.server.service.UserService;
import java.io.StringWriter;
import java.io.Writer;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NamymapEditorAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(NamymapEditorAction.class);
    private static final long serialVersionUID = 1L;
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;
    private final transient LicenseService licenseService;
    private final transient UserService userService;
    private final BootstrapManager bootstrapManager;
    @StrutsParameter
    public String pageId;
    @StrutsParameter
    public String mindmapName;
    @StrutsParameter
    public String lastPage;
    @StrutsParameter
    public String isViewMode;
    @StrutsParameter
    public String isCopyMode;
    @StrutsParameter
    public String isImportMode;
    @StrutsParameter
    public String isEditorMode;
    @StrutsParameter
    public EditorMode editorMode;
    @StrutsParameter
    public Long legacyExternalStoragePageId;
    @StrutsParameter
    public String legacyExternalStorageMindmapName;
    @StrutsParameter
    public Long mindmapPreloadPageId;
    @StrutsParameter
    public String mindmapPreloadMindmapName;
    @StrutsParameter
    public String templateKey;
    @StrutsParameter
    public String templateAction;
    @StrutsParameter
    public String contextPath;
    private boolean hasWritePermission;
    @StrutsParameter
    public String macroName;
    @StrutsParameter
    public String isReadOnly;
    @StrutsParameter
    public String language;

    @Autowired
    public NamymapEditorAction(@NonNull LicenseService licenseService, @NonNull UserService userService, @ComponentImport @NonNull WebResourceAssemblerFactory webResourceAssemblerFactory, @ComponentImport @NonNull BootstrapManager bootstrapManager) {
        if (licenseService == null) {
            throw new NullPointerException("licenseService");
        }
        if (userService == null) {
            throw new NullPointerException("userService");
        }
        if (webResourceAssemblerFactory == null) {
            throw new NullPointerException("webResourceAssemblerFactory");
        }
        if (bootstrapManager == null) {
            throw new NullPointerException("bootstrapManager");
        }
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
        this.licenseService = licenseService;
        this.userService = userService;
        this.bootstrapManager = bootstrapManager;
    }

    public String execute() throws Exception {
        log.info("Execute action:" + this.pageId);
        this.contextPath = this.bootstrapManager.getWebAppContextPath();
        if (!this.licenseService.getLicense().isValid()) {
            this.addActionError("License for EasyMind is not valid!");
            return "error";
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Validate.notNull(user);
        this.setParametersForBackwardCompatibility();
        this.hasWritePermission = this.templateAction == null && NamymapPermissionManager.canWriteMapModelToPage(this.pageId, (User)user);
        this.language = this.userService.getUserLanguage();
        EditorParametersDto editorParametersDto = EditorParametersDto.builder().isViewMode("true".equals(this.isViewMode)).templateAction(this.templateAction).pageId(this.pageId).templateKey(this.templateKey).mindmapName(this.mindmapName).isCopyMode("true".equals(this.isCopyMode)).isImportMode("true".equals(this.isImportMode)).isEditorMode("true".equals(this.isEditorMode)).build();
        this.editorMode = EditorModeFactory.getByParameters(editorParametersDto);
        if ("true".equals(this.isViewMode)) {
            return "success";
        }
        try {
            if (this.pageId != null && this.templateAction != null) {
                throw new IllegalArgumentException("Too many parameters");
            }
            if (StringUtils.isNotBlank(this.pageId) && !this.hasWritePermission) {
                throw new NamymapSecurityException("you are not authorized to edit map from that page");
            }
            if (this.templateAction != null) {
                new TemplateEditObject().checkUserPermission((User)user);
            } else if (this.pageId != null) {
                new PageEditObject(Long.parseLong(this.pageId)).checkUserPermission((User)user);
            }
            return "success";
        }
        catch (Exception e) {
            log.error("Unexpected error", (Throwable)e);
            this.addActionError("Unexpected error:" + e.getMessage());
            return "error";
        }
    }

    @HtmlSafe
    public String getRenderNamymapResourcesHtml() {
        StringWriter stringWriter = new StringWriter();
        WebResourceAssembler assembler = this.webResourceAssemblerFactory.create().includeSuperbatchResources(false).build();
        assembler.resources().requireWebResource("cz.morosystems.atlassian.plugin.easymind:easymind-react-editor-resources");
        assembler.assembled().drainIncludedResources().writeHtmlTags((Writer)stringWriter, UrlMode.AUTO);
        return stringWriter.toString();
    }

    public String getActionName() {
        return "NamymapEditorAction";
    }

    private void setParametersForBackwardCompatibility() {
        if (StringUtils.isNotBlank(this.macroName)) {
            this.setMindmapName(HtmlUtil.urlDecode((String)this.macroName));
        }
        if ("true".equals(this.isReadOnly)) {
            this.setIsViewMode(this.isReadOnly);
        }
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getMindmapName() {
        return this.mindmapName;
    }

    public void setMindmapName(String mindmapName) {
        this.mindmapName = mindmapName;
    }

    public String getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(String lastPage) {
        this.lastPage = lastPage;
    }

    public String getIsViewMode() {
        return this.isViewMode;
    }

    public void setIsViewMode(String isViewMode) {
        this.isViewMode = isViewMode;
    }

    public String getIsCopyMode() {
        return this.isCopyMode;
    }

    public void setIsCopyMode(String isCopyMode) {
        this.isCopyMode = isCopyMode;
    }

    public String getIsImportMode() {
        return this.isImportMode;
    }

    public void setIsImportMode(String isImportMode) {
        this.isImportMode = isImportMode;
    }

    public String getIsEditorMode() {
        return this.isEditorMode;
    }

    public void setIsEditorMode(String isEditorMode) {
        this.isEditorMode = isEditorMode;
    }

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    public Long getLegacyExternalStoragePageId() {
        return this.legacyExternalStoragePageId;
    }

    public void setLegacyExternalStoragePageId(Long legacyExternalStoragePageId) {
        this.legacyExternalStoragePageId = legacyExternalStoragePageId;
    }

    public String getLegacyExternalStorageMindmapName() {
        return this.legacyExternalStorageMindmapName;
    }

    public void setLegacyExternalStorageMindmapName(String legacyExternalStorageMindmapName) {
        this.legacyExternalStorageMindmapName = legacyExternalStorageMindmapName;
    }

    public Long getMindmapPreloadPageId() {
        return this.mindmapPreloadPageId;
    }

    public void setMindmapPreloadPageId(Long mindmapPreloadPageId) {
        this.mindmapPreloadPageId = mindmapPreloadPageId;
    }

    public String getMindmapPreloadMindmapName() {
        return this.mindmapPreloadMindmapName;
    }

    public void setMindmapPreloadMindmapName(String mindmapPreloadMindmapName) {
        this.mindmapPreloadMindmapName = mindmapPreloadMindmapName;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    public String getTemplateAction() {
        return this.templateAction;
    }

    public void setTemplateAction(String templateAction) {
        this.templateAction = templateAction;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isHasWritePermission() {
        return this.hasWritePermission;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public String getIsReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(String isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

