/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence.action;

import cz.morosystems.namymap.common.enums.EditorMode;
import cz.morosystems.namymap.server.model.EditorParametersDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class EditorModeFactory {
    private EditorModeFactory() {
        throw new UnsupportedOperationException();
    }

    public static EditorMode getByParameters(EditorParametersDto editorParametersDto) {
        Validate.notNull(editorParametersDto);
        if (editorParametersDto.isViewMode()) {
            return EditorMode.VIEW;
        }
        if (editorParametersDto.getTemplateAction() != null) {
            return EditorModeFactory.getTemplateMode(editorParametersDto.getTemplateAction());
        }
        return EditorModeFactory.getMindmapMode(editorParametersDto);
    }

    private static EditorMode getTemplateMode(String templateActionName) {
        return "create".equals(templateActionName) ? EditorMode.TEMPLATE_CREATE : EditorMode.TEMPLATE_EDIT;
    }

    private static EditorMode getMindmapMode(EditorParametersDto editorParametersDto) {
        if (editorParametersDto.isEditorMode()) {
            return EditorMode.OPEN_EDITOR;
        }
        if (editorParametersDto.isCopyMode()) {
            return EditorMode.CREATE_FROM_COPY;
        }
        if (editorParametersDto.isImportMode()) {
            return EditorMode.CREATE_FROM_IMPORT;
        }
        if (editorParametersDto.getTemplateKey() != null) {
            return EditorMode.CREATE_FROM_TEMPLATE;
        }
        if (StringUtils.isNotBlank(editorParametersDto.getMindmapName())) {
            return EditorMode.EDIT;
        }
        return EditorMode.CREATE_EMPTY;
    }
}

