/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.confluence;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.opensymphony.xwork2.inject.Inject;
import cz.morosystems.namymap.server.service.MindMapDraftService;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class AppLifecycleListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AppLifecycleListener.class);
    @ConfluenceImport
    private EventPublisher eventPublisher;
    private final TransactionTemplate transactionTemplate;
    private final MindMapDraftService mindMapDraftService;
    private final MindMapTemplateService mindMapTemplateService;

    @Inject
    public AppLifecycleListener(EventPublisher eventPublisher, TransactionTemplate transactionTemplate, MindMapDraftService mindMapDraftService, MindMapTemplateService mindMapTemplateService) {
        this.transactionTemplate = transactionTemplate;
        this.mindMapDraftService = mindMapDraftService;
        this.mindMapTemplateService = mindMapTemplateService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals("cz.morosystems.atlassian.plugin.easymind")) {
            this.transactionTemplate.execute(() -> {
                log.info("EasyMind plugin enabled");
                this.mindMapTemplateService.migrateTemplatesToActiveObjects();
                this.mindMapDraftService.migrateDraftsToActiveObjects();
                return null;
            });
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

