/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.autosave.impl;

import cz.morosystems.namymap.server.autosave.AutoSaveAction;
import cz.morosystems.namymap.server.autosave.AutoSaveActionType;
import cz.morosystems.namymap.server.autosave.impl.DeleteAutoSaveHttpAction;
import cz.morosystems.namymap.server.autosave.impl.LoadAutoSaveHttpAction;
import cz.morosystems.namymap.server.autosave.impl.SaveAutoSaveHttpAction;
import java.util.Locale;

public class AutoSaveActionFactory {
    private AutoSaveActionFactory() {
    }

    public static AutoSaveAction getInstance(String actionType) {
        String type = actionType == null ? "" : actionType.toUpperCase(Locale.getDefault());
        AutoSaveActionType action = AutoSaveActionType.valueOf(AutoSaveActionType.class, type);
        switch (action) {
            case LOAD: {
                return new LoadAutoSaveHttpAction();
            }
            case SAVE: {
                return new SaveAutoSaveHttpAction();
            }
            case DELETE: {
                return new DeleteAutoSaveHttpAction();
            }
        }
        throw new IllegalArgumentException("Unsupported auto save action type");
    }
}

