/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.autosave;

import java.util.regex.Pattern;

public class AutoSaveData {
    public static final String DELIMITER = "|";
    private String userName;
    private String name;
    private String content;
    private long pageId;

    public String getKey() {
        return this.getPageId() + DELIMITER + this.getUserName() + DELIMITER + this.getName();
    }

    public String toString() {
        return String.format("AutoSaveData{pageId=%d, userName=%s, name=%s, content=%s}", this.pageId, this.userName, this.name, this.content);
    }

    public static AutoSaveData fromKey(String key, String content) {
        String[] split = Pattern.compile(DELIMITER, 16).split(key);
        return split.length < 3 ? null : new AutoSaveData(split[1], split[2], content, Long.parseLong(split[0]));
    }

    public String getUserName() {
        return this.userName;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoSaveData)) {
            return false;
        }
        AutoSaveData other = (AutoSaveData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        return this.getPageId() == other.getPageId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoSaveData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        long $pageId = this.getPageId();
        result = result * 59 + (int)($pageId >>> 32 ^ $pageId);
        return result;
    }

    public AutoSaveData(String userName, String name, String content, long pageId) {
        this.userName = userName;
        this.name = name;
        this.content = content;
        this.pageId = pageId;
    }
}

