/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.autosave;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import cz.morosystems.namymap.server.autosave.AutoSaveAction;
import cz.morosystems.namymap.server.autosave.AutoSaveData;
import cz.morosystems.namymap.server.service.MindMapDraftService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoSaveHttpAction
implements AutoSaveAction {
    private static final Logger log = LoggerFactory.getLogger(AbstractAutoSaveHttpAction.class);

    protected AbstractAutoSaveHttpAction() {
    }

    @Override
    public void processAutoSaveAction(MindMapDraftService autoSave, HttpServletResponse resp, AutoSaveData autoSaveData) throws IOException {
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            this.validateInputParams(autoSaveData);
            this.checkUserPermission((User)user, autoSaveData);
            this.processInternalAutoSaveAction(autoSave, resp, autoSaveData);
        }
        catch (IllegalArgumentException iae) {
            log.warn("Cannot process auto save action. AutoSaveDate={}", (Object)autoSaveData.toString(), (Object)iae);
            resp.sendError(400, iae.getMessage());
        }
    }

    protected void validateInputParams(AutoSaveData data) {
        if (data.getName() == null || data.getName().trim().length() == 0) {
            throw new IllegalArgumentException("Macro name is required");
        }
    }

    protected abstract void processInternalAutoSaveAction(MindMapDraftService var1, HttpServletResponse var2, AutoSaveData var3) throws IOException;

    protected abstract void checkUserPermission(User var1, AutoSaveData var2);
}

