/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import cz.morosystems.namymap.server.model.NamymapTemplate;
import cz.morosystems.namymap.server.service.MindMapTemplateService;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowNamymapAdminAction
extends ConfluenceActionSupport {
    private final transient MindMapTemplateService mindMapTemplateService;
    @StrutsParameter
    private List<NamymapTemplate> templates;
    private String editorURL;
    private String adminURL;

    @Autowired
    public ShowNamymapAdminAction(@NonNull MindMapTemplateService mindMapTemplateService) {
        if (mindMapTemplateService == null) {
            throw new NullPointerException("mindMapTemplateService");
        }
        this.mindMapTemplateService = mindMapTemplateService;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        String baseURL = this.getGlobalSettings().getBaseUrl();
        this.editorURL = baseURL + "/plugins/namymap/shownamymapeditor.action";
        this.adminURL = baseURL + "/admin/plugin-repository/namymappluginadmin.action";
        String templateAction = this.getCurrentRequest().getParameter("templateAction");
        String removeKey = this.getCurrentRequest().getParameter("removeKey");
        if ("remove".equals(templateAction) && StringUtils.isNotBlank(removeKey)) {
            this.mindMapTemplateService.deleteTemplate(removeKey);
        }
        this.templates = this.mindMapTemplateService.getAllTemplates();
        return "success";
    }

    public List<NamymapTemplate> getTemplates() {
        return this.templates;
    }

    public String getEditorURL() {
        return this.editorURL;
    }

    public String getAdminURL() {
        return this.adminURL;
    }
}

