/*
 * Decompiled with CFR 0.152.
 */
package cz.morosystems.namymap.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Set;
import java.util.TreeSet;

public class NamymapJsonTopicParser {
    public static final String ROOT_TOPIC = "rootTopic";
    public static final String SUBTOPICS = "subtopics";
    public static final String TOPIC_TITLE = "title";

    public Set<String> parseTopicsFromJson(String json) {
        TreeSet<String> topicList = new TreeSet<String>();
        JsonElement jsonElement = JsonParser.parseString(json);
        if (jsonElement.isJsonObject()) {
            JsonObject mindMap = (JsonObject)jsonElement;
            JsonObject rootTopic = mindMap.get(ROOT_TOPIC).getAsJsonObject();
            this.parseTopic(rootTopic, topicList);
        }
        return topicList;
    }

    private void parseTopic(JsonObject mindMapTopic, Set<String> topicList) {
        if (!mindMapTopic.isJsonNull()) {
            topicList.add(mindMapTopic.get(TOPIC_TITLE).getAsJsonPrimitive().getAsString());
            for (JsonElement subTopic : mindMapTopic.get(SUBTOPICS).getAsJsonArray()) {
                this.parseTopic(subTopic.getAsJsonObject(), topicList);
            }
        }
    }
}

